<div class="pf-hero-2-area pf-mlr-12 wa-p-relative">
    <!-- main-slider -->
    <div class="pf-hero-2-slider">
        <div class="swiper-container wa-fix pf-h2-active">
            <div class="swiper-wrapper">
                <?php foreach ( $settings['slides'] as $slide ) : ?>
                <div class="swiper-slide">
                    <div class="pf-hero-2-slider-item">
                        <?php if(!empty( $slide['image_1']['url'] )) : ?>
                        <div class="pf-hero-2-slider-item-bg">
                            <div class="pf-hero-2-slider-item-img wa-fix wa-img-cover">
                                <img
                                src="<?php echo esc_url($slide['image_1']['url']); ?>"
                                alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $slide['image_1']['url'] ); } ?>">
                            </div>
                        </div>
                        <?php endif; ?>
                        <div class="container pf-container-1">
                            <div class="pf-hero-2-slider-item-content">
                                <div class="left">
                                    <?php
                                        $this->add_render_attribute( 'title', 'class', 'tx-title pf-h-1 hero-title wa-split-1' );
                                        printf('<%1$s %2$s>%3$s</%1$s>',
                                            tag_escape($slide['title_tag']),
                                            $this->get_render_attribute_string('title'),
                                            elh_element_kses_basic( $slide['title'] )
                                        );
                                    ?>
                                    <?php if(!empty( $slide['description'] )) : ?>
                                    <p class="pf-p-1 hero-dic slideup tx-description"><?php echo elh_element_kses_intermediate( $slide['description'] ); ?></p>
                                    <?php endif; ?>
                                </div>

                                <div class="hero-btn slideup">
                                    <a href="<?php echo esc_url($slide['button_link']['url']); ?>"
                                        target="<?php echo esc_attr($slide['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                                        rel="<?php echo esc_attr($slide['button_link']['nofollow'] ? 'nofollow' : ''); ?>"
                                        aria-label="name"
                                        class="pf-rotated-btn-2">
                                        <?php if(!empty( $slide['image_2']['url'] )) : ?>
                                        <img
                                        src="<?php echo esc_url($slide['image_2']['url']); ?>"
                                        alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $slide['image_2']['url'] ); } ?>">
                                        <?php endif; ?>

                                        <?php if(!empty( $slide['button_icon'] )) : ?>
                                        <span class="icon">
                                            <?php \Elementor\Icons_Manager::render_icon( $slide['button_icon'], ['aria-hidden' => 'true'] ); ?>
                                        </span>
                                        <?php endif; ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>

    <!-- preview-slider -->
    <div class="pf-hero-2-slider-preview">
        <div class="swiper-container wa-fix pf-h2-preview-active">
            <div class="swiper-wrapper">
                <?php foreach ( $settings['slides'] as $slide ) : ?>
                <div class="swiper-slide">
                    <div class="pf-hero-2-slider-preview-single">
                        <svg class="h2-progress" width="24" height="24" viewBox="-3 -3 30 30" version="1.1" xmlns="http://www.w3.org/2000/svg" >
                            <circle r="14" cx="12" cy="12" fill="transparent" stroke="#ffe6e3" stroke-width="2.5" stroke-dasharray="12.56px" stroke-dashoffset="0"></circle>
                            <circle r="14" cx="12" cy="12" stroke="#ff2727" stroke-width="2.5" stroke-linecap="round" stroke-dashoffset="12px" fill="transparent" stroke-dasharray="12.56px"></circle>
                            </svg>

                        <?php if(!empty( $slide['sub_title'] )) : ?>
                        <h5 class="pf-h-1 title"><?php echo elh_element_kses_intermediate( $slide['sub_title'] ); ?></h5>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>