<?php

namespace ElementHelper\Widget;
use \ElementHelper\Element_El_Select2;
use \Elementor\Controls_Manager;
use \Elementor\Repeater;
use \Elementor\Utils;

defined( 'ABSPATH' ) || die();

class Tx_Hero_Slider extends Element_El_Widget {

    /**
     * Get widget name.
     *
     * Retrieve Element Helper widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'tx_hero_slider';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title() {
        return __( 'TX Hero Slide', 'mojito-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/gradient-heading/';
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-t-letter';
    }

    public function get_keywords() {
        return ['mojito', 'slide'];
    }

    protected function register_content_controls() {

        //Settings
        $this->start_controls_section(
            '_section_design_settings',
            [
                'label' => __( 'Choos Design', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'mojito-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'mojito-core' ),
                    'style_2' => __( 'Style 2', 'mojito-core' ),
                    'style_3' => __( 'Style 3', 'mojito-core' ),
                    'style_4' => __( 'Style 4', 'mojito-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();

        // IMAGE SECTION
        $this->start_controls_section(
            '_section_image',
            [
                'label' => __( 'Image Info Box', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_2', 'style_3', 'style_4'],
                ],
            ]
        );

        // IMAGE_1
        $this->add_control(
            'image_1',
            [
                'label'   => __( 'Image 1', 'mojito-core' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'design_style' => ['style_2', 'style_4'],
                ],
            ]
        );

         // mask image
         $this->add_control(
            'mask_image',
            [
                'label'       => __( 'Mask Image', 'mojito-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'default'     => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'selectors'   => [
                    '{{WRAPPER}} .pf-hero-5-slider' => 'mask-image: url({{URL}});-webkit-mask-image: url({{URL}});',
                ],
                'condition' => [
                    'design_style' => ['style_2'],
                ],
            ]
        );

        // info text
        $this->add_control(
            'info_text',
            [
                'label'       => __( 'Info Text', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your info text', 'mojito-core' ),
                'default'     => __( 'We are the best', 'mojito-core' ),
                'label_block' => true,
                'condition' => [
                    'design_style' => ['style_2', 'style_3', 'style_4'],
                ],
            ]
        );

        // info icon
        $this->add_control(
            'info_icon',
            [
                'label'   => __( 'Info Icon', 'mojito-core' ),
                'type'    => Controls_Manager::ICONS,
                'default' => [
                    'value'   => 'fas fa-check',
                    'library' => 'solid',
                ],
                'condition' => [
                    'design_style' => ['style_3', 'style_4'],
                ],
            ]
        );

        // info link
        $this->add_control(
            'info_link',
            [
                'label'       => __( 'Info Link', 'mojito-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'Enter your info link', 'mojito-core' ),
                'default'     => [
                    'url' => '#',
                ],
                'condition' => [
                    'design_style' => ['style_3', 'style_4'],
                ],
            ]
        );

        // END
        $this->end_controls_section();

        // scroll down
        $this->start_controls_section(
            '_section_scroll_down',
            [
                'label' => __( 'Scroll Down', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // enable scroll down
        $this->add_control(
            'enable_scroll_down',
            [
                'label'        => __( 'Enable Scroll Down', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // scroll text
        $this->add_control(
            'scroll_text',
            [
                'label'       => __( 'Scroll Text', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your scroll text', 'mojito-core' ),
                'default'     => __( 'Scroll Down', 'mojito-core' ),
                'label_block' => true,
            ]
        );

        // scroll icon
        $this->add_control(
            'scroll_icon',
            [
                'label'   => __( 'Scroll Icon', 'mojito-core' ),
                'type'    => Controls_Manager::ICONS,
                'default' => [
                    'value'   => 'fas fa-long-arrow-alt-down',
                    'library' => 'solid',
                ],
            ]
        );

        // scroll link
        $this->add_control(
            'scroll_link',
            [
                'label'       => __( 'Scroll Link', 'mojito-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'Enter your scroll link', 'mojito-core' ),
                'default'     => [
                    'url' => '#',
                ],
            ]
        );

        // END
        $this->end_controls_section();

        // SLIDE ITEMS
        $this->start_controls_section(
            '_section_slide_items',
            [
                'label' => __( 'Slide Items', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        // design style
        $repeater->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'mojito-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'mojito-core' ),
                    'style_2' => __( 'Style 2', 'mojito-core' ),
                    'style_3' => __( 'Style 3', 'mojito-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
                'description'        => __( 'Please ensure the style matches the one you selected above.', 'mojito-core' ),
            ]
        );

        // image_1
        $repeater->add_control(
            'image_1',
            [
                'label'   => __( 'Image 1', 'mojito-core' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'design_style' => ['style_1', 'style_2'],
                ],
            ]
        );

        // image_1
        $repeater->add_control(
            'image_2',
            [
                'label'   => __( 'Image 2', 'mojito-core' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'design_style' => ['style_1'],
                ],
            ]
        );

        // sub title
        $repeater->add_control(
            'sub_title',
            [
                'label'       => __( 'Sub Title', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your sub title', 'mojito-core' ),
                'default'     => __( 'We are the best', 'mojito-core' ),
                'label_block' => true,
            ]
        );

        // title
        $repeater->add_control(
            'title',
            [
                'label'       => __( 'Title', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your title', 'mojito-core' ),
                'default'     => __( 'We are the best', 'mojito-core' ),
                'label_block' => true,
            ]
        );

        // tag
        $repeater->add_control(
            'title_tag',
            [
                'label'   => __( 'Title HTML Tag', 'mojito-core' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => __( 'H1', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h1',
                    ],
                    'h2' => [
                        'title' => __( 'H2', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h2',
                    ],
                    'h3' => [
                        'title' => __( 'H3', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h3',
                    ],
                    'h4' => [
                        'title' => __( 'H4', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h4',
                    ],
                    'h5' => [
                        'title' => __( 'H5', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h5',
                    ],
                    'h6' => [
                        'title' => __( 'H6', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h6',
                    ],
                ],
                'default' => 'h2',
                'toggle'  => false,
            ]
        );

        // description
        $repeater->add_control(
            'description',
            [
                'label'       => __( 'Description', 'mojito-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your description', 'mojito-core' ),
                'default'     => __( 'We are the best', 'mojito-core' ),
                'condition' => [
                    'design_style' => ['style_1', 'style_2'],
                ],
            ]
        );

        // button text
        $repeater->add_control(
            'button_text',
            [
                'label'       => __( 'Button Text', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your button text', 'mojito-core' ),
                'default'     => __( 'Get Started', 'mojito-core' ),
                'condition' => [
                    'design_style' => ['style_2'],
                ],
            ]
        );

        // button link
        $repeater->add_control(
            'button_link',
            [
                'label'       => __( 'Button Link', 'mojito-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'Enter your button link', 'mojito-core' ),
                'default'     => [
                    'url' => '#',
                ],
                'condition' => [
                    'design_style' => ['style_1', 'style_2'],
                ],
            ]
        );

        // button icon
        $repeater->add_control(
            'button_icon',
            [
                'label'       => __( 'Button Icon', 'mojito-core' ),
                'type'        => Controls_Manager::ICONS,
                'placeholder' => __( 'Enter your button icon', 'mojito-core' ),
                'default'     => [
                    'value'   => 'fas fa-long-arrow-right',
                    'library' => 'fa-solid',
                ],
            ]
        );

        // cat_name
        $repeater->add_control(
            'cat_name',
            [
                'label'       => __( 'Category Name', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your category name', 'mojito-core' ),
                'default'     => __( 'Category', 'mojito-core' ),
                'condition' => [
                    'design_style' => ['style_2'],
                ],
            ]
        );

        // add repeater
        $this->add_control(
            'slides',
            [
                'label'  => __( 'Slides', 'mojito-core' ),
                'type'   => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_list_items',
            [
                'label' => __( 'Social Links', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_2'],
                ],
            ]
        );

        // enable social links
        $this->add_control(
            'enable_social_links',
            [
                'label'        => __( 'Enable Social Links', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $repeater = new \Elementor\Repeater();

        // list icon
        $repeater->add_control(
            'social_icon',
            [
                'label'       => __( 'Icon', 'mojito-core' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fas fa-check',
                    'library' => 'solid',
                ],
                'label_block' => true,
            ]
        );

        // social_text
        $repeater->add_control(
            'social_text',
            [
                'label'       => __( 'Text', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => 'Social Text',
            ]
        );

        // list_link
        $repeater->add_control(
            'social_link',
            [
                'label'       => __( 'Social Link', 'mojito-core' ),
                'type'        => Controls_Manager::URL,
                'label_block' => true,
                'default'     => [
                    'url' => '#',
                ],
            ]
        );

        $this->add_control(
            'social_links',
            [
                'label'       => __( 'Social Links', 'mojito-core' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
            ]
        );

        $this->end_controls_section();

        // SETTINGS
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => __( 'Settings', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // enable_slider_pagination
        $this->add_control(
            'enable_slider_pagination',
            [
                'label'        => __( 'Enable Slider Pagination', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'mojito-core' ),
                'label_off'    => __( 'No', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // END
        $this->end_controls_section();

    }

    protected function register_style_controls() {

        $dir = dirname( __FILE__ );
        $style_files = glob( $dir . '/styles/*.php' );

        if ( $style_files ) {
            foreach ( $style_files as $style_file ) {
                include $style_file;
            }
        }

    }

    protected function render() {

        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        $style = !empty( $settings['design_style'] ) ? $settings['design_style'] : 'style_1';

        switch ( $style ) {
        case 'style_5':
            include $dir . '/views/view-5.php';
            break;
        case 'style_4':
            include $dir . '/views/view-4.php';
            break;
        case 'style_3':
            include $dir . '/views/view-3.php';
            break;
        case 'style_2':
            include $dir . '/views/view-2.php';
            break;
        default:
            include $dir . '/views/view-1.php';
        }
    }
}
