<section class="mt-hero-section-3 txt_item_active position-relative">
    <?php if(!empty( $settings['image_1']['url'] )) : ?>
    <span class="hero_shape_1 position-absolute">
        <img
            src="<?php echo esc_url($settings['image_1']['url']); ?>"
            alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_1']['url'] ); } ?>">
    </span>
    <?php endif; ?>

    <?php if(!empty( $settings['image_2']['url'] )) : ?>
    <span class="hero_shape_2 position-absolute">
    <img
        src="<?php echo esc_url($settings['image_2']['url']); ?>"
        alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_2']['url'] ); } ?>">
    </span>
    <?php endif; ?>

    <div class="container mt-container-1">
        <div class="mt-hero-content-3 position-relative">
            <div class="mt-hero-text-3 headline pera-content ul-li">
                <?php if( $settings['enable_sub_title'] === 'yes' ) : ?>
                <div class="hero-subtitlte wow fadeInRight"  data-wow-delay="300ms" data-wow-duration="1000ms">
                    <span><?php echo elh_element_kses_intermediate($settings['sub_title']); ?></span>
                </div>
                <?php endif; ?>

                <?php
                if($settings['enable_title'] === 'yes') {
                    $this->add_render_attribute( 'title', 'class', 'tx-title hero_title tx-split-text banner_title_line' );
                        printf('<%1$s %2$s>%3$s</%1$s>',
                            tag_escape($settings['title_tag']),
                            $this->get_render_attribute_string('title'),
                            elh_element_kses_basic( $settings['title'] )
                        );
                    }
                    if( $settings['enable_description'] === 'yes' ) :
                ?>
                <div class="hero-list wow fadeInRight"  data-wow-delay="400ms" data-wow-duration="1000ms">
                    <?php
                        $list_items = explode("\n", $settings['description']);
                    ?>
                    <ul>
                        <?php foreach ($list_items as $list_item): ?>
                        <li>
                            <?php echo elh_element_kses_intermediate($list_item); ?>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>

                <?php if( $settings['enable_button'] === 'yes' ) : ?>
                <div class="mt-btn-3 ver_3 mt-30 wow fadeInRight"  data-wow-delay="300ms" data-wow-duration="1000ms">
                    <a class="text-uppercase tx-button" href="<?php echo esc_url($settings['button_link']['url']); ?>"
                    target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                    rel="<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                        <?php echo esc_html($settings['button_text']); ?>
                        <?php
                            if(!empty( $settings['enable_button_icon'] === 'yes') ) {
                                \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] );
                            }
                        ?>
                    </a>
                </div>
                <?php endif; ?>
            </div>

            <div class="mt-hero-img-3 txt_item_active">
                <?php if(!empty( $settings['image_3']['url'] )) : ?>
                <div class="item-img">
                    <img
                    src="<?php echo esc_url($settings['image_3']['url']); ?>"
                    alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_3']['url'] ); } ?>">
                </div>
                <?php endif; ?>

                <?php if(!empty( $settings['image_4']['url'] )) : ?>
                <div class="item-bottom">
                    <img
                src="<?php echo esc_url($settings['image_4']['url']); ?>"
                alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_4']['url'] ); } ?>">
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>