<section class="mt-hero-section-2 position-relative" data-background="<?php echo esc_url($settings['image_1']['url']) ? esc_url($settings['image_1']['url']) : ''; ?>">
    <div class="mt-hero-social position-absolute">
        <?php if( $settings['enable_social_links'] === 'yes' ) : ?>
        <div class="item-social">
            <?php foreach( $settings['social_links'] as $list ) : ?>
            <a href="<?php echo esc_url($list['social_link']['url']); ?>"
            target="<?php echo esc_attr( $list['social_link']['is_external'] ? '_blank' : '_self' ); ?>"
            rel="<?php echo esc_attr( $list['social_link']['nofollow'] ? 'nofollow' : '' ); ?>">
                <?php \Elementor\Icons_Manager::render_icon( $list['social_icon'], [ 'aria-hidden' => 'true' ] ); ?>
            </a>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>

        <?php if( $settings['enable_contact_info'] === 'yes' ) : ?>
        <div class="item-cta">
            <a href="<?php echo esc_url($settings['contact_info_link']['url']); ?>"
            target="<?php echo esc_attr( $settings['contact_info_link']['is_external'] ? '_blank' : '_self' ); ?>"
            rel="<?php echo esc_attr( $settings['contact_info_link']['nofollow'] ? 'nofollow' : '' ); ?>">
                <?php \Elementor\Icons_Manager::render_icon( $settings['contact_info_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                <?php echo esc_html($settings['contact_info_text']); ?>
            </a>
        </div>
        <?php endif; ?>
    </div>
    <div class="mt-hero-content-2 txt_item_active position-relative">
        <?php if(!empty( $settings['image_2']['url'] )) : ?>
        <span class="hero-shape-2 position-absolute">
            <img
            src="<?php echo esc_url($settings['image_2']['url']); ?>"
            alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_2']['url'] ); } ?>">
        </span>
        <?php endif; ?>

        <div class="hero-img">
            <?php if(!empty( $settings['image_3']['url'] )) : ?>
            <div class="item-img">
                <img
                src="<?php echo esc_url($settings['image_3']['url']); ?>"
                alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_3']['url'] ); } ?>">
            </div>
            <?php endif; ?>
            <?php if(!empty( $settings['image_4']['url'] )) : ?>
            <span class="item-shape-1 position-absolute">
                <img
                src="<?php echo esc_url($settings['image_4']['url']); ?>"
                alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_4']['url'] ); } ?>">
            </span>
            <?php endif; ?>

            <?php if(!empty( $settings['image_5']['url'] )) : ?>
            <span class="item-shape-2 position-absolute">
                <img
                src="<?php echo esc_url($settings['image_5']['url']); ?>"
                alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_5']['url'] ); } ?>">
            </span>
            <?php endif; ?>
        </div>
        <div class="mt-hero-text txt_item_active mt-text position-relative headline pera-content">
            <?php if(!empty( $settings['image_6']['url'] )) : ?>
            <span class="hero-shape-1 position-absolute">
                <img
                src="<?php echo esc_url($settings['image_6']['url']); ?>"
                alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_6']['url'] ); } ?>">
            </span>
            <?php endif; ?>

            <?php if( $settings['enable_sub_title'] === 'yes' ) : ?>
            <div class="hero-slug d-flex align-items-center wow fadeInRight"  data-wow-delay="300ms" data-wow-duration="1000ms">
                <span><?php echo elh_element_kses_intermediate($settings['sub_title']); ?></span>
                <?php \Elementor\Icons_Manager::render_icon( $settings['sub_title_icon'], [ 'aria-hidden' => 'true' ] ); ?>
            </div>
            <?php endif; ?>

            <?php
                if($settings['enable_title'] === 'yes') {
                $this->add_render_attribute( 'title', 'class', 'tx-title hero_title title_text title_text' );
                    printf('<%1$s %2$s>%3$s</%1$s>',
                        tag_escape($settings['title_tag']),
                        $this->get_render_attribute_string('title'),
                        elh_element_kses_basic( $settings['title'] )
                    );
                }
                if( $settings['enable_description'] === 'yes' ) :
            ?>
            <p><?php echo elh_element_kses_intermediate($settings['description']); ?></p>
            <?php endif; ?>

            <div class="hero-progress-wrap d-flex align-items-center flex-wrap mt-30 wow fadeInUp"  data-wow-delay="400ms" data-wow-duration="1000ms">
                <?php if(!empty( $settings['image_7']['url'] )) : ?>
                <div class="play-icon d-flex justify-content-center align-items-center">
                    <img
                    src="<?php echo esc_url($settings['image_7']['url']); ?>"
                    alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_7']['url'] ); } ?>">
                </div>
                <?php endif; ?>

                <?php if( $settings['enable_skill_box'] === 'yes' ) : ?>
                <div class="hero-progress-bar">
                    <div class="skill-set-percent">
                        <?php foreach($settings['skill_lists'] as $list) : ?>
                        <div class="progress">
                            <?php if(!empty( $list['skill_title'] )) : ?>
                            <h4>
                                <?php echo esc_html($list['skill_title']); ?>
                            </h4>
                            <?php endif; ?>

                            <?php if(!empty( $list['skill_value'] )) : ?>
                            <div class="progress-bar" data-percent="<?php echo esc_attr($list['skill_value']); ?>"></div>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endif; ?>

            </div>

            <?php if( $settings['enable_button'] === 'yes' ) : ?>
            <div class="mt-btn-3 mt-45 wow fadeInUp" data-wow-delay="400ms" data-wow-duration="1000ms">
                <a class="tx-button text-uppercase" href="<?php echo esc_url($settings['button_link']['url']); ?>"
                    target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                    rel="<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                    <?php echo esc_html($settings['button_text']); ?>
                    <?php
                        if(!empty( $settings['enable_button_icon'] === 'yes') ) {
                            \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] );
                        }
                    ?>
                </a>
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>