<section class="mt-hero-section-1 position-relative tx-section" data-background="<?php echo esc_url($settings['image_1']['url']) ? esc_url($settings['image_1']['url']) : ''; ?>">
    <div class="container mt-container-1">
        <div class="mt-hero-content">
            <div class="mt-hero-text-1 mt-text headline pera-content">
                <?php
                    if($settings['enable_title'] === 'yes') {
                    $this->add_render_attribute( 'title', 'class', 'tx-title hero_title title_text title_text_ani txt_item_active' );
                        printf('<%1$s %2$s>%3$s</%1$s>',
                            tag_escape($settings['title_tag']),
                            $this->get_render_attribute_string('title'),
                            elh_element_kses_basic( $settings['title'] )
                        );
                    }
                    if(!empty( $settings['description'] )) :
                ?>
                <p><?php echo elh_element_kses_intermediate($settings['description']); ?></p>
                <?php endif; ?>

                <?php if( $settings['enable_button'] === 'yes' ) : ?>
                <div class="mt-btn-1 text-uppercase text-center">
                    <a class="tx-button" href="<?php echo esc_url($settings['button_link']['url']); ?>"
                    target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                    rel="<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                        <?php if(!empty( $settings['button_text'] )) : ?>
                        <span><?php echo esc_html($settings['button_text']); ?></span>
                        <?php endif; ?>
                        <?php
                            if(!empty( $settings['enable_button_icon'] === 'yes') ) {
                                \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] );
                            }
                        ?>
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>