<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

$this->start_controls_section(
    '_section_style_title',
    [
        'label' => __( 'HEADING STYLE', 'mojito-core' ),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

// enable full width
$this->add_control(
    'enable_full_width',
    [
        'label'        => __( 'Enable Full Width', 'mojito-core' ),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __( 'Yes', 'mojito-core' ),
        'label_off'    => __( 'No', 'mojito-core' ),
        'return_value' => 'yes',
        'default'      => 'no',
    ]
);

// enable title animation
$this->add_control(
    'enable_title_animation',
    [
        'label'        => __( 'Enable Title Animation', 'mojito-core' ),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __( 'Yes', 'mojito-core' ),
        'label_off'    => __( 'No', 'mojito-core' ),
        'return_value' => 'yes',
        'default'      => 'yes',
    ]
);

// title color
$this->add_control(
    'title_color',
    [
        'label'     => __( 'Title Color', 'mojito-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .tx-title' => 'color: {{VALUE}};',
        ],
    ]
);

// title span color
$this->add_control(
    'title_span_color',
    [
        'label'     => __( 'Title Span Color', 'mojito-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .tx-title span' => 'color: {{VALUE}};',
        ],
    ]
);

// title padding
$this->add_responsive_control(
    'title_padding',
    [
        'label'      => __( 'Padding', 'mojito-core' ),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', 'em', '%'],
        'selectors'  => [
            '{{WRAPPER}} .tx-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

// title margin
$this->add_responsive_control(
    'title_margin',
    [
        'label'      => __( 'Margin', 'mojito-core' ),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', 'em', '%'],
        'selectors'  => [
            '{{WRAPPER}} .tx-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

// title typography
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'     => 'title_typography',
        'label'    => __( 'Typography', 'mojito-core' ),
        'selector' => '
        {{WRAPPER}} .tx-title
        ',
    ]
);

$this->end_controls_section();