<?php
    $enable_custom_link = $settings['enable_custom_link'];
    if($enable_custom_link == 'yes') {
        $custom_link = $settings['custom_link']['url'];
    } else {
        $custom_link = home_url( '/' );
    }

    // enable position
    $enable_position_absolute = $settings['enable_position_absolute'];
    if($enable_position_absolute == 'yes') {
        $position_absolute = ' position-absolute';
    } else {
        $position_absolute = '';
    }

    // enable sticky header
    $enable_sticky_header = $settings['enable_sticky_header'];
    if($enable_sticky_header === 'yes') {
        $sticky_header = 'txa_sticky_header';
    } else {
        $sticky_header = '';
    }
?>
<header class="mt-header-section header_style_four <?php echo esc_attr($sticky_header . $position_absolute); ?>">
    <div class="mt-header-content d-flex justify-content-between">
        <div class="mt-header-trigger open_mobile_menu">
            <span></span>
            <span></span>
            <span></span>
        </div>
        <?php if(!empty( $settings['logo']['url'] )) : ?>
        <div class="brand-logo">
            <a href="<?php echo esc_url($custom_link); ?>"
                class="pf-header-2-logo tx-logo"
                aria-label="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['logo']['url'] ); } ?>">
                <img src="<?php echo esc_url($settings['logo']['url']); ?>"
                alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['logo']['url'] ); } ?>">
            </a>
        </div>
        <?php endif; ?>
        <div class="header-action d-flex justify-content-between">
            <button class="search_btn_toggle"><i class="fas fa-search"></i></button>

            <?php if( $settings['enable_phone_info'] === 'yes' ) : ?>
            <div class="cta-wrap d-flex align-items-center">
                <?php if(!empty( $settings['contact_info_icon'] )) : ?>
                <div class="item-icon d-flex justify-content-center align-items-center">
                    <?php \Elementor\Icons_Manager::render_icon( $settings['contact_info_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                </div>
                <?php endif; ?>

                <div class="item-text headline pera-content">
                    <?php if(!empty( $settings['contact_info_label'] )) : ?>
                    <span>
                        <?php echo esc_html($settings['contact_info_label']); ?>
                    </span>
                    <?php endif;
                        if(!empty( $settings['contact_info_text'] )) :
                        switch ($settings['link_type']) {
                            case 'url':
                                $contact_info_text = $settings['contact_info_text'];
                                break;
                            case 'email':
                                $contact_info_text = 'mailto:' . $settings['contact_info_text'];
                                break;
                            case 'phone':
                                $contact_info_text = 'tel:' . $settings['contact_info_text'];
                                break;
                            default:
                                $contact_info_text = '#';
                                break;
                        }
                    ?>
                    <a href="<?php echo esc_url($contact_info_text); ?>"><?php echo esc_html($settings['contact_info_text']); ?></a>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</header>

<!-- mobil menu -->
<div class="mobile_menu lenis lenis-smooth position-relative">
	<div class="mobile_menu_wrap">
		<div class="mobile_menu_overlay open_mobile_menu"></div>
		<div class="mobile_menu_content">
			<div class="mobile_menu_close open_mobile_menu">
				<i class="fas fa-times"></i>
			</div>

			<div class="m-brand-logo">
				<a href="<?php echo esc_url($custom_link); ?>"
				aria-label="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['mobile_logo']['url'] ); } ?>"
				aria-label="name" class="pf-header-1-logo tx-logo">
					<img src="<?php echo esc_url($settings['mobile_logo']['url']); ?>"
					alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['mobile_logo']['url'] ); } ?>">
				</a>
			</div>

			<?php if( $settings['enable_search'] === 'yes' ) : ?>
			<div class="mobile-search-bar position-relative">
				<form method="get" action="<?php print esc_url(home_url('/')); ?>">
					<input type="search" name="s"
					aria-label="search"
					placeholder="<?php print esc_attr($settings['search_placeholder']); ?>"
					value="<?php print esc_attr( get_search_query() )?>">
					<button><i class="fas fa-search"></i></button>
				</form>
			</div>
			<?php endif; ?>

			<?php if ( !empty( $settings['select_mobile_menu'] ) ) : ?>
			<nav class="mobile-main-navigation  clearfix ul-li">
				<?php include $dir . '/parts/main-menu.php'; ?>
			</nav>
			<?php endif; ?>

			<?php if( $settings['enable_social_links'] === 'yes' ) : ?>
			<div class="ptx-mobile-header-social text-center">
				<?php foreach($settings['social_links'] as $list ) : ?>
				<a href="<?php echo esc_url($list['social_link']['url']) ?>"
				target="<?php echo esc_attr( $list['social_link']['is_external'] ? '_blank' : '_self' ); ?>"
				rel="<?php echo esc_attr( $list['social_link']['nofollow'] ? 'nofollow' : '' ); ?>"
				class="txa-offcanvas-social-item pf-h-1 fx-font-500" aria-label="name">
					<?php \Elementor\Icons_Manager::render_icon( $list['social_icon'], [ 'aria-hidden' => 'true' ] ); ?>
				</a>
				<?php endforeach; ?>
			</div>
			<?php endif; ?>
		</div>
	</div>
</div>

<?php if( $settings['enable_search'] === 'yes' ) : ?>
<div class="txa-search-box search_box_active ">

    <div class="txa-search-container">
        <div class="txa-search-wrap text-center mb-55">
            <?php if(!empty( $settings['search_button_text'] )) : ?>
            <h5 class="txa-search-title fx-heading-1 fx-font-500"><?php echo elh_element_kses_intermediate($settings['search_button_text']); ?></h5>
            <?php endif; ?>

            <form method="get" action="<?php print esc_url(home_url('/')); ?>" class="txa-search-form">
                <input class="txa-search-form-input" type="search" name="s"
                aria-label="search"
                placeholder="<?php print esc_attr($settings['search_placeholder']); ?>"
                value="<?php print esc_attr( get_search_query() )?>">
            </form>
        </div>

        <?php if( $settings['enable_populer_tags'] === 'yes' ) : ?>
        <div class="txa-search-tag-wrap text-center">
            <?php if(!empty( $settings['populer_tag_heading'] )) : ?>
            <h6 class="txa-search-tag-title fx-font-400 fx-heading-1">
                <?php echo elh_element_kses_intermediate($settings['populer_tag_heading']); ?>
            </h6>
            <?php endif; ?>

            <div class="txa-search-tag d-inline-flex flex-wrap">
                <?php foreach($settings['populer_tags'] as $list) : ?>
                <a href="<?php echo esc_url($list['populer_tag_link']['url']); ?>" aria-label="name" class="txa-search-tag-item fx-heading-1 fx-font-500">
                    <?php echo elh_element_kses_intermediate($list['populer_tag_text']); ?>
                </a>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <button aria-label="search-close" type="button" class="txa-search-box-close search_box_close">
        <i class="fas fa-times"></i>
    </button>
</div>
<?php endif; ?>