<?php
    $enable_custom_link = $settings['enable_custom_link'];
    if($enable_custom_link == 'yes') {
        $custom_link = $settings['custom_link']['url'];
    } else {
        $custom_link = home_url( '/' );
    }

    // enable position
    $enable_position_absolute = $settings['enable_position_absolute'];
    if($enable_position_absolute == 'yes') {
        $position_absolute = ' position-absolute';
    } else {
        $position_absolute = '';
    }

    // enable sticky header
    $enable_sticky_header = $settings['enable_sticky_header'];
    if($enable_sticky_header === 'yes') {
        $sticky_header = 'txa_sticky_header';
    } else {
        $sticky_header = '';
    }
?>
<header id="mt-header" class="mt-header-section header_style_two tx-header <?php echo esc_attr($sticky_header . $position_absolute); ?>">
    <div class="mt-header-content d-flex justify-content-between align-items-center">
        <?php if(!empty( $settings['logo']['url'] )) : ?>
        <div class="brand-logo">
            <a href="<?php echo esc_url($custom_link); ?>"
                class="pf-header-2-logo tx-logo"
                aria-label="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['logo']['url'] ); } ?>">
                <img src="<?php echo esc_url($settings['logo']['url']); ?>"
                alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['logo']['url'] ); } ?>">
            </a>
        </div>
        <?php endif; ?>

        <?php if ( !empty( $settings['select_menu'] ) ) : ?>
        <nav class="main-navigation clearfix ul-li">
            <?php include $dir . '/parts/main-menu.php'; ?>
        </nav>
        <?php endif; ?>

        <div class="header-search-offcanvas d-flex align-items-center">
            <?php if( $settings['enable_search'] === 'yes' ) : ?>
            <button class="search_btn_toggle"><i class="fas fa-search"></i></button>
            <?php endif; ?>

            <button class="offcanvas-area offcanvas_toggle">
                <span></span>
                <span></span>
                <span></span>
                <span></span>
            </button>
        </div>
        <button class="mobile-menu-btn mobile_menu_button open_mobile_menu">
            <span></span>
            <span></span>
            <span></span>
        </button>
    </div>
</header>

<div class="mobile_menu lenis lenis-smooth position-relative">
	<div class="mobile_menu_wrap">
		<div class="mobile_menu_overlay open_mobile_menu"></div>
		<div class="mobile_menu_content">
			<div class="mobile_menu_close open_mobile_menu">
				<i class="fas fa-times"></i>
			</div>

			<div class="m-brand-logo">
				<a href="<?php echo esc_url($custom_link); ?>"
				aria-label="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['logo']['url'] ); } ?>"
				aria-label="name" class="pf-header-1-logo tx-logo">
					<img src="<?php echo esc_url($settings['logo']['url']); ?>"
					alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['logo']['url'] ); } ?>">
				</a>
			</div>

			<?php if( $settings['enable_search'] === 'yes' ) : ?>
			<div class="mobile-search-bar position-relative">
				<form method="get" action="<?php print esc_url(home_url('/')); ?>">
					<input type="search" name="s"
					aria-label="search"
					placeholder="<?php print esc_attr($settings['search_placeholder']); ?>"
					value="<?php print esc_attr( get_search_query() )?>">
					<button><i class="fas fa-search"></i></button>
				</form>
			</div>
			<?php endif; ?>

			<?php if ( !empty( $settings['select_mobile_menu'] ) ) : ?>
			<nav class="mobile-main-navigation  clearfix ul-li">
				<?php include $dir . '/parts/main-menu.php'; ?>
			</nav>
			<?php endif; ?>

			<?php if( $settings['enable_social_links'] === 'yes' ) : ?>
			<div class="ptx-mobile-header-social text-center">
				<?php foreach($settings['social_links'] as $list ) : ?>
				<a href="<?php echo esc_url($list['social_link']['url']) ?>"
				target="<?php echo esc_attr( $list['social_link']['is_external'] ? '_blank' : '_self' ); ?>"
				rel="<?php echo esc_attr( $list['social_link']['nofollow'] ? 'nofollow' : '' ); ?>"
				class="txa-offcanvas-social-item pf-h-1 fx-font-500" aria-label="name">
					<?php \Elementor\Icons_Manager::render_icon( $list['social_icon'], [ 'aria-hidden' => 'true' ] ); ?>
				</a>
				<?php endforeach; ?>
			</div>
			<?php endif; ?>
		</div>
	</div>
</div>

<!-- offcanvas-start -->
<div class="txa-offcanvas-box lenis lenis-smooth offcanvas_box_active">
    <button class="txa-offcanvas-box-close offcanvas_box_close" aria-label="name" >
        <i class="fas fa-times"></i>
    </button>
    <div class="txa-offcanvas-box-container">

        <!-- services -->
        <div class="txa-offcanvas-services-wrap d-lg-block ul-li-block d-none">
            <?php if(!empty( $settings['side_info_heading'] )) : ?>
            <h5 class="txa-offcanvas-services-title fx-heading-1 fx-font-400">
                <?php echo elh_element_kses_intermediate($settings['side_info_heading']); ?>
            </h5>
            <?php endif; ?>

            <ul class="txa-offcanvas-services">

                <?php foreach($settings['side_info_lists'] as $list) : ?>
                <li>
                    <span class="offcanvas-slideup">
                        <a class="txa-offcanvas-services-item fx-heading-1 fx-font-400"
                        href="<?php echo esc_url($list['list_link']['url']); ?>"
                        target="<?php echo esc_attr( $list['list_link']['is_external'] ? '_blank' : '_self' ); ?>"
                        rel="<?php echo esc_attr( $list['list_link']['nofollow'] ? 'nofollow' : '' ); ?>"
                        aria-label="name">
                            <?php \Elementor\Icons_Manager::render_icon( $list['side_info_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                            <?php echo elh_element_kses_intermediate($list['list_label']); ?>
                        </a>
                    </span>
                </li>
                <?php endforeach; ?>

            </ul>
        </div>

        <?php if( $settings['enable_search'] === 'yes' ) : ?>
        <div class="txa-offcanvas-search d-lg-none d-block">
            <form method="get" action="<?php print esc_url(home_url('/')); ?>" class="txa-offcanvas-search-form">
                <input class="txa-offcanvas-search-form-input" type="search" name="s"
                aria-label="search"
                placeholder="<?php print esc_attr($settings['search_placeholder']); ?>"
                value="<?php print esc_attr( get_search_query() )?>">
                <button class="txa-offcanvas-search-form-btn" type="button" aria-label="name">
                    <?php \Elementor\Icons_Manager::render_icon( $settings['search_button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                </button>
            </form>
        </div>
        <?php endif; ?>

        <!-- mobile-menu-list -->
        <?php if ( !empty( $settings['select_mobile_menu'] ) ) : ?>
        <div class="mobile-menu-navigation d-lg-none d-block">
            <nav class="mobile-main-navigation  clearfix ul-li">
                <?php include $dir . '/parts/main-menu.php'; ?>
            </nav>
        </div>
        <?php endif; ?>

        <div class="txa-offcanvas-content">

            <!-- contact -->
            <div class="txa-offcanvas-content-box  ul-li-block">
                <?php if(!empty( $settings['quick_contact_heading'] )) : ?>
                <h6 class="txa-offcanvas-content-box-title fx-heading-1 text-capitalize fx-font-400">
                    <?php echo elh_element_kses_intermediate($settings['quick_contact_heading']); ?>
                </h6>
                <?php endif; ?>

                <ul class="txa-offcanvas-contact">
                    <?php foreach($settings['quick_contact_lists'] as $list) : ?>
                    <li class="fx-heading-1 fix" >
                        <span class="offcanvas-slideup">
                            <?php
                                if(!empty( $list['quick_contact_icon'] )) {
                                    \Elementor\Icons_Manager::render_icon( $list['quick_contact_icon'], [ 'aria-hidden' => 'true' ] );
                                }
                            ?>
                            <?php echo elh_element_kses_intermediate($list['quick_contact_label']); ?>
                        </span>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </div>

            <!-- socail -->
            <?php if( $settings['enable_social_links'] === 'yes' ) : ?>
            <div class="txa-offcanvas-content-box ul-li-block">
                <?php if(!empty( $settings['social_heading'] )) : ?>
                <h6 class="txa-offcanvas-content-box-title text-capitalize fx-heading-1 fx-font-400">
                    <?php echo elh_element_kses_intermediate($settings['social_heading']); ?>
                </h6>
                <?php endif; ?>

                <ul class="txa-offcanvas-social">
                    <?php foreach($settings['social_links'] as $list ) : ?>
                    <li>
                        <span class="offcanvas-slideup">
                            <a href="<?php echo esc_url($list['social_link']['url']) ?>"
                            target="<?php echo esc_attr( $list['social_link']['is_external'] ? '_blank' : '_self' ); ?>"
                            rel="<?php echo esc_attr( $list['social_link']['nofollow'] ? 'nofollow' : '' ); ?>"
                            class="txa-offcanvas-social-item fx-heading-1 fx-font-500" aria-label="name">
                                <?php \Elementor\Icons_Manager::render_icon( $list['social_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                <?php echo elh_element_kses_intermediate($list['social_label']); ?>
                            </a>
                        </span>
                    </li>
                    <?php endforeach; ?>

                </ul>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php if( $settings['enable_search'] === 'yes' ) : ?>
<div class="txa-search-box search_box_active ">

    <div class="txa-search-container">
        <div class="txa-search-wrap text-center mb-55">
            <?php if(!empty( $settings['search_button_text'] )) : ?>
            <h5 class="txa-search-title fx-heading-1 fx-font-500"><?php echo elh_element_kses_intermediate($settings['search_button_text']); ?></h5>
            <?php endif; ?>

            <form method="get" action="<?php print esc_url(home_url('/')); ?>" class="txa-search-form">
                <input class="txa-search-form-input" type="search" name="s"
                aria-label="search"
                placeholder="<?php print esc_attr($settings['search_placeholder']); ?>"
                value="<?php print esc_attr( get_search_query() )?>">
            </form>
        </div>

        <?php if( $settings['enable_populer_tags'] === 'yes' ) : ?>
        <div class="txa-search-tag-wrap text-center">
            <?php if(!empty( $settings['populer_tag_heading'] )) : ?>
            <h6 class="txa-search-tag-title fx-font-400 fx-heading-1">
                <?php echo elh_element_kses_intermediate($settings['populer_tag_heading']); ?>
            </h6>
            <?php endif; ?>

            <div class="txa-search-tag d-inline-flex flex-wrap">
                <?php foreach($settings['populer_tags'] as $list) : ?>
                <a href="<?php echo esc_url($list['populer_tag_link']['url']); ?>" aria-label="name" class="txa-search-tag-item fx-heading-1 fx-font-500">
                    <?php echo elh_element_kses_intermediate($list['populer_tag_text']); ?>
                </a>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <button aria-label="search-close" type="button" class="txa-search-box-close search_box_close">
        <i class="fas fa-times"></i>
    </button>
</div>
<?php endif; ?>