<?php
    $enable_custom_link = $settings['enable_custom_link'];
    if($enable_custom_link == 'yes') {
        $custom_link = $settings['custom_link']['url'];
    } else {
        $custom_link = home_url( '/' );
    }

    // enable position
    $enable_position_absolute = $settings['enable_position_absolute'];
    if($enable_position_absolute == 'yes') {
        $position_absolute = ' position-absolute';
    } else {
        $position_absolute = '';
    }

    // enable sticky header
    $enable_sticky_header = $settings['enable_sticky_header'];
    if($enable_sticky_header === 'yes') {
        $sticky_header = 'txa_sticky_header';
    } else {
        $sticky_header = '';
    }
?>
<header class="mt-header-section header_style_one tx-header <?php echo esc_attr($sticky_header . $position_absolute); ?>">
	<div class="mt-header-content d-flex justify-content-between align-items-center">
		<?php if(!empty( $settings['logo']['url'] )) : ?>
		<div class="brand-logo">
            <a href="<?php echo esc_url($custom_link); ?>"
            aria-label="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['logo']['url'] ); } ?>"
            aria-label="name" class="pf-header-1-logo tx-logo">
                <img src="<?php echo esc_url($settings['logo']['url']); ?>"
                alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['logo']['url'] ); } ?>">
            </a>
		</div>
		<?php endif; ?>

		<?php if ( !empty( $settings['select_menu'] ) ) : ?>
		<nav class="main-navigation clearfix ul-li">
			<?php include $dir . '/parts/main-menu.php'; ?>
		</nav>
		<?php endif; ?>

		<div class="header-cta-mobile-btn d-flex align-items-center">

			<?php if( $settings['enable_button'] === 'yes' ) : ?>
			<div class="header-cta-btn position-relative text-uppercase">
				<div class="btn-glow"></div>
				<a class="tx-button"
                href="<?php echo esc_url($settings['button_link']['url']) ?>"
                target="<?php echo esc_attr( $settings['button_link']['is_external'] ? '_blank' : '_self' ); ?>"
                rel="<?php echo esc_attr( $settings['button_link']['nofollow'] ? 'nofollow' : '' ); ?>"
                aria-label="<?php echo esc_attr($settings['button_text']); ?>">
					<span>
						<?php
							echo esc_html($settings['button_text']);
							if( !empty($settings['button_icon']) ) \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] );
						?>
					</span>
				</a>
			</div>
			<?php endif; ?>

			<button class="mobile-menu-btn mobile_menu_button open_mobile_menu">
				<span></span>
				<span></span>
				<span></span>
			</button>
		</div>
	</div>
</header>

<!-- Mobile Menu -->
<div class="mobile_menu lenis lenis-smooth position-relative">
	<div class="mobile_menu_wrap">
		<div class="mobile_menu_overlay open_mobile_menu"></div>
		<div class="mobile_menu_content">
			<div class="mobile_menu_close open_mobile_menu">
				<i class="fas fa-times"></i>
			</div>

			<div class="m-brand-logo">
				<a href="<?php echo esc_url($custom_link); ?>"
				aria-label="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['logo']['url'] ); } ?>"
				aria-label="name" class="pf-header-1-logo tx-logo">
					<img src="<?php echo esc_url($settings['logo']['url']); ?>"
					alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['logo']['url'] ); } ?>">
				</a>
			</div>

			<?php if( $settings['enable_search'] === 'yes' ) : ?>
			<div class="mobile-search-bar position-relative">
				<form method="get" action="<?php print esc_url(home_url('/')); ?>">
					<input type="search" name="s"
					aria-label="search"
					placeholder="<?php print esc_attr($settings['search_placeholder']); ?>"
					value="<?php print esc_attr( get_search_query() )?>">
					<button><i class="fas fa-search"></i></button>
				</form>
			</div>
			<?php endif; ?>

			<?php if ( !empty( $settings['select_mobile_menu'] ) ) : ?>
			<nav class="mobile-main-navigation  clearfix ul-li">
				<?php include $dir . '/parts/main-menu.php'; ?>
			</nav>
			<?php endif; ?>

			<?php if( $settings['enable_social_links'] === 'yes' ) : ?>
			<div class="ptx-mobile-header-social text-center">
				<?php foreach($settings['social_links'] as $list ) : ?>
				<a href="<?php echo esc_url($list['social_link']['url']) ?>"
				target="<?php echo esc_attr( $list['social_link']['is_external'] ? '_blank' : '_self' ); ?>"
				rel="<?php echo esc_attr( $list['social_link']['nofollow'] ? 'nofollow' : '' ); ?>"
				class="txa-offcanvas-social-item pf-h-1 fx-font-500" aria-label="name">
					<?php \Elementor\Icons_Manager::render_icon( $list['social_icon'], [ 'aria-hidden' => 'true' ] ); ?>
				</a>
				<?php endforeach; ?>
			</div>
			<?php endif; ?>
		</div>
	</div>
</div>