<?php

namespace ElementHelper\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Repeater;
use \Elementor\Utils;

defined( 'ABSPATH' ) || die();

class Tx_Headers extends Element_El_Widget {

    /**
     * Get widget name.
     *
     * Retrieve Mojito Core widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'tx_headers';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title() {
        return __( 'TX Headers', 'mojito-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/gradient-heading/';
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-t-letter';
    }

    public function get_keywords() {
        return ['btn', 'header', 'mojito', 'mojito header'];
    }

    // get menu by slug
    public function get_menu() {
        $menus = wp_get_nav_menus();
        $menu_list = [];
        if ( $menus ) {
            foreach ( $menus as $menu ) {
                $menu_list[$menu->slug] = $menu->name;
            }
        }
        return $menu_list;
    }

    protected function register_content_controls() {

        //Settings
        $this->start_controls_section(
            '_section_design_settings',
            [
                'label' => __( 'DESIGN STYLE', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'mojito-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Header One', 'mojito-core' ),
                    'style_2' => __( 'Header two', 'mojito-core' ),
                    'style_3' => __( 'Header three', 'mojito-core' ),
                    'style_4' => __( 'Header Four', 'mojito-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();


        // logo section
        $this->start_controls_section(
            '_section_logo',
            [
                'label' => __( 'Logo', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // logo
        $this->add_control(
            'logo',
            [
                'label'       => __( 'Logo', 'mojito-core' ),
                'type'        => Controls_Manager::MEDIA,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'label_block' => true,
            ]
        );

        // enable custom link
        $this->add_control(
            'enable_custom_link',
            [
                'label'        => __( 'Enable Custom Link', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'mojito-core' ),
                'label_off'    => __( 'No', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );

        // custom link
        $this->add_control(
            'custom_link',
            [
                'label'       => __( 'Custom Link', 'mojito-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'mojito-core' ),
                'show_label'  => false,
                'default'     => [
                    'url' => '#',
                ],
                'condition'   => [
                    'enable_custom_link' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'logo_width',
            [
                'label'      => esc_html__( 'Max Width', 'gesto-plugin' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 5000,
                    ],
                ],

                'selectors'  => [
                    '{{WRAPPER}} .tx-logo img' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // mobile logo
        $this->add_control(
            'mobile_logo',
            [
                'label'       => __( 'Mobile Logo', 'mojito-core' ),
                'type'        => Controls_Manager::MEDIA,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'label_block' => true,
            ]
        );

        // end logo section
        $this->end_controls_section();

        $this->start_controls_section(
            '_section_menu',
            [
                'label' => __( 'Menu Options', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // select menu
        $this->add_control(
            'select_menu',
            [
                'label'       => __( 'Select Menu', 'mojito-core' ),
                'type'        => Controls_Manager::SELECT2,
                'options'     => $this->get_menu(),
                'label_block' => true,
                'multiple'    => false,
            ]
        );

        // select mobile menu
        $this->add_control(
            'select_mobile_menu',
            [
                'label'       => __( 'Select Mobile Menu', 'mojito-core' ),
                'type'        => Controls_Manager::SELECT2,
                'options'     => $this->get_menu(),
                'label_block' => true,
                'multiple'    => false,
            ]
        );

        $this->end_controls_section();

        // BUTTON SECTION
        $this->start_controls_section(
            '_section_button',
            [
                'label'     => __( 'Button', 'mojito-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_1', 'style_3'],
                ],
            ]
        );

        $this->add_control(
            'enable_button',
            [
                'label'        => __( 'Enable Button', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'mojito-core' ),
                'label_off'    => __( 'No', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // button text
        $this->add_control(
            'button_text',
            [
                'label'       => __( 'Button Text', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Get Started', 'mojito-core' ),
                'label_block' => true,
            ]
        );

        // button link
        $this->add_control(
            'button_link',
            [
                'label'       => __( 'Button Link', 'mojito-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'mojito-core' ),
                'show_label'  => false,
                'default'     => [
                    'url' => '#',
                ],
            ]
        );

        // button icon
        $this->add_control(
            'button_icon',
            [
                'label'       => __( 'Button Icon', 'mojito-core' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fal fa-long-arrow-right',
                    'library' => 'solid',
                ],
                'label_block' => true,
            ]
        );

        // END BUTTON SECTION
        $this->end_controls_section();

        // side info section
        $this->start_controls_section(
            '_section_scoial_info',
            [
                'label'     => __( 'Social Links', 'mojito-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'enable_social_links' => 'yes',
                ],
            ]
        );

        // social_heading
           $this->add_control(
            'social_heading',
            [
                'label'       => __( 'Social Heading', 'pixify-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Follow Us', 'pixify-core' ),
                'label_block' => true,
                'condition'   => [
                    'design_style' => ['style_2'],
                ],
            ]
        );

        // reapeter
        $repeater = new \Elementor\Repeater();

        // social_icon
        $repeater->add_control(
            'social_icon',
            [
                'label'       => __( 'Social Icon', 'mojito-core' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fab fa-facebook-f',
                    'library' => 'solid',
                ],
                'label_block' => true,
            ]
        );

         // social_label
         $repeater->add_control(
            'social_label',
            [
                'label'       => __( 'Social Label', 'pixify-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Facebook', 'pixify-core' ),
                'label_block' => true,
            ]
        );

        // social_link
        $repeater->add_control(
            'social_link',
            [
                'label'       => __( 'Social Link', 'mojito-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'mojito-core' ),
                'show_label'  => false,
                'default'     => [
                    'url' => '#',
                ],
            ]
        );

        // social_links
        $this->add_control(
            'social_links',
            [
                'label'  => __( 'Social Links', 'mojito-core' ),
                'type'   => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        // END side info section
        $this->end_controls_section();

        // search box
        $this->start_controls_section(
            '_section_search',
            [
                'label'     => __( 'Search Box', 'mojito-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'enable_search' => 'yes',
                ],
            ]
        );

        // search placeholder
        $this->add_control(
            'search_placeholder',
            [
                'label'       => __( 'Search Placeholder', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Search...', 'mojito-core' ),
                'label_block' => true,
            ]
        );

        // search button text
        $this->add_control(
            'search_button_text',
            [
                'label'       => __( 'Search Button Text', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Search', 'mojito-core' ),
                'label_block' => true,
            ]
        );

        // search button icon
        $this->add_control(
            'search_button_icon',
            [
                'label'       => __( 'Search Button Icon', 'mojito-core' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fa fa-search',
                    'library' => 'solid',
                ],
                'label_block' => true,
            ]
        );

        // enable popular tags
        $this->add_control(
            'enable_populer_tags',
            [
                'label'        => __( 'Enable Populer Tags', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'mojito-core' ),
                'label_off'    => __( 'No', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // populer tag heading
        $this->add_control(
            'populer_tag_heading',
            [
                'label'       => __( 'Populer Tag Heading', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'People also search for:', 'mojito-core' ),
                'label_block' => true,
            ]
        );

        // repeater
        $repeater = new Repeater();

        // populer tag text
        $repeater->add_control(
            'populer_tag_text',
            [
                'label'       => __( 'Populer Tag Text', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Corporate', 'mojito-core' ),
                'label_block' => true,
            ]
        );

        // populer tag link
        $repeater->add_control(
            'populer_tag_link',
            [
                'label'       => __( 'Populer Tag Link', 'mojito-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'mojito-core' ),
                'show_label'  => false,
                'default'     => [
                    'url' => '#',
                ],
            ]
        );

        // populer tags
        $this->add_control(
            'populer_tags',
            [
                'label'  => __( 'Populer Tags', 'mojito-core' ),
                'type'   => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        // end
        $this->end_controls_section();

        // contact info box
        $this->start_controls_section(
            '_section_contact_info_box',
            [
                'label'     => __( 'Contact Info Box', 'mojito-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_3', 'style_4'],
                ],
            ]
        );

        // enable contact info
        $this->add_control(
            'enable_phone_info',
            [
                'label'        => __( 'Enable Phone Info', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // contact info icon
        $this->add_control(
            'contact_info_icon',
            [
                'label'     => __( 'Contact Info Icon', 'mojito-core' ),
                'type'      => Controls_Manager::ICONS,
                'default'   => [
                    'value'   => 'fas fa-phone',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'enable_contact_info' => 'yes',
                ],
            ]
        );

        // contact info label
        $this->add_control(
            'contact_info_label',
            [
                'label'       => __( 'Contact Info Label', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Contact Info Label', 'mojito-core' ),
                'placeholder' => __( 'Enter your contact info label', 'mojito-core' ),
                'condition'   => [
                    'enable_contact_info' => 'yes',
                ],
            ]
        );

        // contact info text
        $this->add_control(
            'contact_info_text',
            [
                'label'       => __( 'Contact Info Text', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Contact Info Text', 'mojito-core' ),
                'placeholder' => __( 'Enter your contact info text', 'mojito-core' ),
                'condition'   => [
                    'enable_contact_info' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'link_type',
            [
                'label'          => __( 'Choose Link Type', 'mojito-core' ),
                'type'           => Controls_Manager::CHOOSE,
                'label_block'    => false,
                'options'        => [
                    'url'   => [
                        'title' => __( 'URL', 'mojito-core' ),
                        'icon'  => 'far fa-globe',
                    ],
                    'email' => [
                        'title' => __( 'Email', 'mojito-core' ),
                        'icon'  => 'fa fa-envelope',
                    ],
                    'phone' => [
                        'title' => __( 'Phone', 'mojito-core' ),
                        'icon'  => 'fa fa-phone',
                    ],
                ],
                'toggle'         => false,
                'style_transfer' => true,
                'default'        => 'email',
                'condition'      => [
                    'enable_contact_info' => 'yes',
                ],
            ]
        );

        // end
        $this->end_controls_section();

        // SIDE INFO
        $this->start_controls_section(
            '_section_side_info',
            [
                'label' => __( 'Side Info', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // enable side info
        $this->add_control(
            'enable_side_info',
            [
                'label'        => __( 'Enable Side Info', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'mojito-core' ),
                'label_off'    => __( 'No', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // side info heading
        $this->add_control(
            'side_info_heading',
            [
                'label'       => __( 'Side Info Heading', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Side Info Heading', 'mojito-core' ),
                'placeholder' => __( 'Enter your side info heading', 'mojito-core' ),
                'condition'   => [
                    'enable_side_info' => 'yes',
                ],
            ]
        );

        // enable side info list
        $this->add_control(
            'enable_side_info_list',
            [
                'label'        => __( 'Enable Side Info List', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'mojito-core' ),
                'label_off'    => __( 'No', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'enable_side_info' => 'yes',
                ],
            ]
        );

        // reapeter
        $repeater = new Repeater();

        // side_info_icon
        $repeater->add_control(
            'side_info_icon',
            [
                'label'       => __( 'Side Info Icon', 'mojito-core' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fas fa-check',
                    'library' => 'solid',
                ],
                'label_block' => true,
            ]
        );

        // list label
        $repeater->add_control(
            'list_label',
            [
                'label'       => __( 'List Label', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'List Label', 'mojito-core' ),
                'placeholder' => __( 'Enter your list label', 'mojito-core' ),
                'label_block' => true,
            ]
        );

        // list link
        $repeater->add_control(
            'list_link',
            [
                'label'       => __( 'List Link', 'mojito-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'mojito-core' ),
                'show_label'  => false,
            ]
        );

        // side info lists
        $this->add_control(
            'side_info_lists',
            [
                'label'  => __( 'Side Info Lists', 'mojito-core' ),
                'type'   => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        // enbale qucik contact
        $this->add_control(
            'enable_quick_contact',
            [
                'label'        => __( 'Enable Quick Contact', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'mojito-core' ),
                'label_off'    => __( 'No', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'enable_side_info' => 'yes',
                ],
            ]
        );

        // quick contact heading
        $this->add_control(
            'quick_contact_heading',
            [
                'label'       => __( 'Quick Contact Heading', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Quick Contact Heading', 'mojito-core' ),
                'placeholder' => __( 'Enter your quick contact heading', 'mojito-core' ),
                'condition'   => [
                    'enable_quick_contact' => 'yes',
                ],
            ]
        );

        // repeater
        $repeater = new Repeater();

        // quick contact icon
        $repeater->add_control(
            'quick_contact_icon',
            [
                'label'       => __( 'Quick Contact Icon', 'mojito-core' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fas fa-check',
                    'library' => 'solid',
                ],
                'label_block' => true,
            ]
        );

        // quick contact label
        $repeater->add_control(
            'quick_contact_label',
            [
                'label'       => __( 'Quick Contact Label', 'mojito-core' ),
                'type'        => Controls_Manager::WYSIWYG,
                'default'     => __( 'Quick Contact Label', 'mojito-core' ),
                'placeholder' => __( 'Enter your quick contact label', 'mojito-core' ),
                'label_block' => true,
            ]
        );

        // quick contact lists
        $this->add_control(
            'quick_contact_lists',
            [
                'label'  => __( 'Quick Contact Lists', 'mojito-core' ),
                'type'   => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        // END
        $this->end_controls_section();

        // settings section
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => __( 'SETTINGS', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // enable sticky header
        $this->add_control(
            'enable_sticky_header',
            [
                'label'        => __( 'ENABLE STICKY HEADER', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'mojito-core' ),
                'label_off'    => __( 'No', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        //

        // ENABLE CONTACT INFO
        $this->add_control(
            'enable_contact_info',
            [
                'label'        => __( 'ENABLE CONTACT INFO?', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'mojito-core' ),
                'label_off'    => __( 'No', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // enable search
        $this->add_control(
            'enable_search',
            [
                'label'        => __( 'Enable Search', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'mojito-core' ),
                'label_off'    => __( 'No', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // enable social links
        $this->add_control(
            'enable_social_links',
            [
                'label'        => __( 'Enable Social Links', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'mojito-core' ),
                'label_off'    => __( 'No', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // enable_cart_icon
        $this->add_control(
            'enable_cart_icon',
            [
                'label'        => __( 'Enable Cart Icon', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'mojito-core' ),
                'label_off'    => __( 'No', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'design_style' => ['style_2'],
                ],
            ]
        );

        // has inner page
        $this->add_control(
            'has_inner_page',
            [
                'label'        => __( 'Has Inner Page', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'mojito-core' ),
                'label_off'    => __( 'No', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );

        // end settings section
        $this->end_controls_section();

    }

    protected function register_style_controls() {

        $dir = dirname( __FILE__ );
        $style_files = glob( $dir . '/styles/*.php' );

        if ( $style_files ) {
            foreach ( $style_files as $style_file ) {
                include $style_file;
            }
        }

    }

    protected function render() {

        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        $style = !empty( $settings['design_style'] ) ? $settings['design_style'] : 'style_1';

        switch ( $style ) {
        case 'style_8':
            include $dir . '/views/view-8.php';
            break;
        case 'style_7':
            include $dir . '/views/view-7.php';
            break;
        case 'style_6':
            include $dir . '/views/view-6.php';
            break;
        case 'style_5':
            include $dir . '/views/view-5.php';
            break;
        case 'style_4':
            include $dir . '/views/view-4.php';
            break;
        case 'style_3':
            include $dir . '/views/view-3.php';
            break;
        case 'style_2':
            include $dir . '/views/view-2.php';
            break;
        default:
            include $dir . '/views/view-1.php';
        }
    }
}
