<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;


// HEADER STYLE
$this->start_controls_section(
    '_section_style_header',
    [
        'label' => __( 'Header', 'mojito-core' ),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

// ENABLE POSITION ABSOLUTE
$this->add_control(
    'enable_position_absolute',
    [
        'label'        => __( 'Enable Position Absolute', 'mojito-core' ),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __( 'Yes', 'mojito-core' ),
        'label_off'    => __( 'No', 'mojito-core' ),
        'return_value' => 'yes',
    ]
);

// HEADER TOP POSITION
$this->add_responsive_control(
    'header_top_position',
    [
        'label'      => __( 'Header Top Position', 'mojito-core' ),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%'],
        'range'      => [
            'px' => [
                'min' => 0,
                'max' => 200,
            ],
            '%'  => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'selectors'  => [
            '{{WRAPPER}} .tx-header' => 'top: {{SIZE}}{{UNIT}};',
        ],
        'condition'  => [
            'enable_position_absolute' => 'yes',
        ],
    ]
);

// section background control
$this->add_group_control(
    \Elementor\Group_Control_Background::get_type(),
    [
        'name'     => 'service_section_background',
        'label'    => __( 'Background', 'gilroy-core' ),
        'types'    => [ 'classic', 'gradient' ],
        'selector' => '{{WRAPPER}} .tx-header .mt-header-content',
    ]
);

// search icon size
$this->add_control(
    'search_icon_size',
    [
        'label'     => __( 'Search Icon Size', 'mojito-core' ),
        'type'      => Controls_Manager::SLIDER,
        'size_units' => [ 'px', 'em', 'rem' ],
        'range'     => [
            'px' => [
                'min' => 10,
                'max' => 100,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .gly-search-btn-1' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
    ]
);

// SEARCH ICON COLOR
$this->add_control(
    'search_icon_color',
    [
        'label'     => __( 'Search Icon Color', 'mojito-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .gly-search-btn-1' => 'color: {{VALUE}};',
        ],
    ]
);

// SEARCH ICON HOVER COLOR
$this->add_control(
    'search_icon_hover_color',
    [
        'label'     => __( 'Search Icon Hover Color', 'mojito-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .gly-search-btn-1:hover' => 'color: {{VALUE}};',
        ],
    ]
);

// mobile hamburger icon size
$this->add_control(
    'mobile_hamburger_icon_size',
    [
        'label'     => __( 'Mobile Hamburger Icon Size', 'mojito-core' ),
        'type'      => Controls_Manager::SLIDER,
        'size_units' => [ 'px', 'em', 'rem' ],
        'range'     => [
            'px' => [
                'min' => 10,
                'max' => 100,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .gly-mobile-menu-btn-22' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
        ],
    ]
);

// MOBILE HAMBURGER ICON COLOR
$this->add_control(
    'mobile_hamburger_icon_color',
    [
        'label'     => __( 'Mobile Hamburger Icon Color', 'mojito-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .gly-mobile-menu-btn-2 span' => 'color: {{VALUE}};',
        ],
    ]
);

// MOBILE HAMBURGER ICON HOVER COLOR
$this->add_control(
    'mobile_hamburger_icon_hover_color',
    [
        'label'     => __( 'Mobile Hamburger Icon Hover Color', 'mojito-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .gly-mobile-menu-btn-2:hover span' => 'color: {{VALUE}};',
        ],
    ]
);

// MOBILE HAMBURGER ICON bg color
$this->add_control(
    'mobile_hamburger_icon_bg_color',
    [
        'label'     => __( 'Mobile Hamburger Icon Background Color', 'mojito-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .gly-mobile-menu-btn-2' => 'background-color: {{VALUE}};',
        ],
    ]
);

// MOBILE HAMBURGER ICON HOVER bg color
$this->add_control(
    'mobile_hamburger_icon_hover_bg_color',
    [
        'label'     => __( 'Mobile Hamburger Icon Hover Background Color', 'mojito-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .gly-mobile-menu-btn-2:hover' => 'background-color: {{VALUE}};',
        ],
    ]
);

// END HEADER STYLE
$this->end_controls_section();
