<?php if( $settings['enable_search'] === 'yes' ) : ?>
<div class="txa-search-box has-default search_box_active">
    <div class="txa-search-container">
        <div class="txa-search-wrap text-center mb-55">
            <?php if(!empty( $settings['search_button_text'] )) : ?>
            <h5 class="txa-search-title fx-heading-1 fx-font-500"><?php echo elh_element_kses_intermediate($settings['search_button_text']); ?></h5>
            <?php endif; ?>

            <form method="get" action="<?php print esc_url(home_url('/')); ?>" class="txa-search-form">
                <input class="txa-search-form-input" type="search" name="s"
                aria-label="search"
                placeholder="<?php print esc_attr($settings['search_placeholder']); ?>"
                value="<?php print esc_attr( get_search_query() )?>">
            </form>
        </div>

        <?php if( $settings['enable_populer_tags'] === 'yes' ) : ?>
        <div class="txa-search-tag-wrap text-center">
            <?php if(!empty( $settings['populer_tag_heading'] )) : ?>
            <h6 class="txa-search-tag-title fx-font-400 fx-heading-1"><?php echo elh_element_kses_intermediate($settings['populer_tag_heading']); ?></h6>
            <?php endif; ?>

            <div class="txa-search-tag d-inline-flex flex-wrap">
                <?php foreach($settings['populer_tags'] as $list) : ?>
                <a href="<?php echo esc_url($list['populer_tag_link']['url']); ?>" aria-label="name" class="txa-search-tag-item fx-heading-1 fx-font-500">
                    <?php echo elh_element_kses_intermediate($list['populer_tag_text']); ?>
                </a>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <button aria-label="search-close" type="button" class="txa-search-box-close search_box_close">
        <i class="fa-solid fa-xmark"></i>
    </button>
</div>
<?php endif; ?>

<div class="txa-offcanvas-box has-default  offcanvas_box_active">
    <button class="txa-offcanvas-box-close offcanvas_box_close" aria-label="name" >
        <i class="fa-solid fa-xmark"></i>
    </button>
    <div class="txa-offcanvas-box-container lenis lenis-smooth">

        <!-- services -->
        <div class="txa-offcanvas-services-wrap d-lg-block d-none">
            <?php if(!empty( $settings['side_info_heading'] )) : ?>
            <h5 class="txa-offcanvas-services-title pf-h-1">
                <?php echo elh_element_kses_intermediate($settings['side_info_heading']); ?>
            </h5>
            <?php endif; ?>

            <ul class="txa-offcanvas-services list-unstyled">
                <?php foreach($settings['side_info_lists'] as $list) : ?>
                <li>
                    <span class="offcanvas-slideup">
                        <a class="txa-offcanvas-services-item pf-h-1"
                        href="<?php echo esc_url($list['list_link']['url']); ?>"
                        target="<?php echo esc_attr( $list['list_link']['is_external'] ? '_blank' : '_self' ); ?>"
                        rel="<?php echo esc_attr( $list['list_link']['nofollow'] ? 'nofollow' : '' ); ?>"
                        aria-label="name">
                            <?php \Elementor\Icons_Manager::render_icon( $list['side_info_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                            <?php echo elh_element_kses_intermediate($list['list_label']); ?>
                        </a>
                    </span>
                </li>
                <?php endforeach; ?>
            </ul>
        </div>

        <?php if( $settings['enable_search'] === 'yes' ) : ?>
        <div class="txa-offcanvas-search d-lg-none d-block">
            <form method="get" action="<?php print esc_url(home_url('/')); ?>" class="txa-offcanvas-search-form">
                <input class="txa-offcanvas-search-form-input" type="search" name="s"
                aria-label="search"
                placeholder="<?php print esc_attr($settings['search_placeholder']); ?>"
                value="<?php print esc_attr( get_search_query() )?>">
                <button class="txa-offcanvas-search-form-btn" type="button" aria-label="name">
                    <?php \Elementor\Icons_Manager::render_icon( $settings['search_button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                </button>
            </form>
        </div>
        <?php endif; ?>

        <!-- mobile-menu-list -->
        <?php if ( !empty( $settings['select_menu'] ) ) : ?>
        <div class="mobile-menu-navigation d-lg-none d-block">
            <nav class="mobile-main-navigation  clearfix ul-li">
                <?php
                    $menu_args = [
                        'menu'        => '' . $settings['select_menu'] . '',
                        'menu_class'     => 'nav navbar-nav clearfix list-unstyled',
                        'menu_id'        => 'main-nav',
                        'walker'         => class_exists('Tx_Mega_Menu_Walker') ? new Tx_Mega_Menu_Walker : '',
                        'fallback_cb'    => ['Navwalker_Class', 'fallback'],
                        'echo'           => false,
                    ];

                    $menu = wp_nav_menu($menu_args);
                    $menu = str_replace('menu-item-has-children', 'dropdown', $menu);
                    $menu = str_replace('sub-menu', 'dropdown-menu', $menu);

                    echo wp_kses_post($menu);
                ?>
            </nav>
        </div>
        <?php endif; ?>

        <div class="txa-offcanvas-content">

            <!-- contact -->
            <div class="txa-offcanvas-content-box">
                <?php if(!empty( $settings['quick_contact_heading'] )) : ?>
                <h6 class="txa-offcanvas-content-box-title pf-h-1">
                    <?php echo elh_element_kses_intermediate($settings['quick_contact_heading']); ?>
                </h6>
                <?php endif; ?>

                <ul class="txa-offcanvas-contact list-unstyled">
                    <?php foreach($settings['quick_contact_lists'] as $list) : ?>
                    <li class="pf-h-1 fix" >
                        <span class="offcanvas-slideup">
                            <?php
                                if(!empty( $list['quick_contact_icon'] )) {
                                    \Elementor\Icons_Manager::render_icon( $list['quick_contact_icon'], [ 'aria-hidden' => 'true' ] );
                                }
                            ?>
                            <?php echo elh_element_kses_intermediate($list['quick_contact_label']); ?>
                        </span>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </div>

            <!-- socail -->
            <?php if( $settings['enable_social_links'] === 'yes' ) : ?>
            <div class="txa-offcanvas-content-box">
                <?php if(!empty( $settings['social_heading'] )) : ?>
                <h6 class="txa-offcanvas-content-box-title pf-h-1">
                    <?php echo elh_element_kses_intermediate($settings['social_heading']); ?>
                </h6>
                <?php endif; ?>

                <ul class="txa-offcanvas-social list-unstyled">
                    <?php foreach($settings['social_links'] as $list ) : ?>
                    <li>
                        <span class="offcanvas-slideup">
                            <a href="<?php echo esc_url($list['social_link']['url']) ?>"
                            target="<?php echo esc_attr( $list['social_link']['is_external'] ? '_blank' : '_self' ); ?>"
                            rel="<?php echo esc_attr( $list['social_link']['nofollow'] ? 'nofollow' : '' ); ?>"
                            class="txa-offcanvas-social-item pf-h-1 fx-font-500" aria-label="name">
                                <?php \Elementor\Icons_Manager::render_icon( $list['social_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                <?php echo elh_element_kses_intermediate($list['social_label']); ?>
                            </a>
                        </span>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>