<!-- free-phone -->
<?php if( $settings['enable_header_top_left'] === 'yes' ) : ?>
<a href="#" aria-label="name" class="pf-free-phone-1">
    <?php if(!empty( $settings['header_top_call_icon'] )) : ?>
    <span class="icon">
        <?php \Elementor\Icons_Manager::render_icon( $settings['header_top_call_icon'], [ 'aria-hidden' => 'true' ] ); ?>
    </span>
    <?php endif; ?>
    <?php echo elh_element_kses_intermediate($settings['header_top_call_label']); ?>
    <?php echo elh_element_kses_intermediate($settings['header_top_call_number']); ?>
</a>
<?php endif; ?>

<!-- search -->
<?php if(!empty( $settings['header_top_search_heading'] )) : ?>
<button type="button" aria-label="name" class="pf-search-btn-2 search_btn_toggle">
    <i data-feather="search"></i>
    <?php echo elh_element_kses_intermediate($settings['header_top_search_heading']); ?>
</button>
<?php endif; ?>

<!-- join-btn -->
<?php if( $settings['enable_header_top_button'] === 'yes' ) : ?>
<a href="<?php echo esc_url($settings['header_top_button_link']['url']) ?>"
target="<?php echo esc_attr( $settings['header_top_button_link']['is_external'] ? '_blank' : '_self' ); ?>"
rel="<?php echo esc_attr( $settings['header_top_button_link']['nofollow'] ? 'nofollow' : '' ); ?>"
aria-label="name" class="pf-join-btn-1">
    <?php echo elh_element_kses_intermediate($settings['header_top_button_text']); ?>
    <?php if(!empty(  $settings['header_top_button_icon'] )) : ?>
    <span class="icon">
        <?php \Elementor\Icons_Manager::render_icon( $settings['header_top_button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
    </span>
    <?php endif; ?>
</a>
<?php endif; ?>

<!-- social -->
<?php if( $settings['header_top_enable_social_links'] === 'yes' ) : ?>
<div class="pf-footer-1-social">
    <?php foreach($settings['header_top_social_links'] as $list ) : ?>
    <a href="<?php echo esc_url($list['social_link']['url']) ?>"
        target="<?php echo esc_attr( $list['social_link']['is_external'] ? '_blank' : '_self' ); ?>"
        rel="<?php echo esc_attr( $list['social_link']['nofollow'] ? 'nofollow' : '' ); ?>"
        aria-label="name"
        data-bs-toggle="tooltip"
        data-bs-placement="top"
        title="<?php echo esc_attr($list['social_label']); ?>">
        <?php \Elementor\Icons_Manager::render_icon( $list['social_icon'], [ 'aria-hidden' => 'true' ] ); ?>
    </a>
    <?php endforeach; ?>
</div>
<?php endif; ?>