<div class="mt-expert-digital-content pt-40 text-center ul-li tx-listItems m-0">
    <ul>
        <?php foreach( $settings['list_items'] as $list ) : ?>
        <li>
            <a href="<?php echo esc_url($list['feature_link']['url']); ?>"
            target="<?php echo esc_attr($list['feature_link']['is_external'] ? '_blank' : '_self'); ?>"
            rel="<?php echo esc_attr($list['feature_link']['nofollow'] ? 'nofollow' : ''); ?>">

                <?php if( $list['enable_icon'] == true ) : ?>
                <span class="item-img">
                    <?php if ( $list['type'] == 'icon' ): ?>
                        <?php \Elementor\Icons_Manager::render_icon( $list['feature_icon'], ['aria-hidden' => 'true'] );?>
                    <?php else: ?>
                        <img src="<?php echo esc_url( $list['feature_image']['url'] ); ?>" alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $list['feature_image']['url'] ); } ?>" />
                    <?php endif;?>
                </span>
                <?php endif; ?>

                <?php if(!empty( $list['feature_text'] )) : ?>
                <span class="item-text"><?php echo esc_html( $list['feature_text'] ); ?></span>
                <?php endif; ?>

                <?php \Elementor\Icons_Manager::render_icon( $settings['feature_icon'], ['aria-hidden' => 'true'] );?>
            </a>
        </li>
        <?php endforeach; ?>
    </ul>
</div>