<?php $rand = rand( 1, 1000 ); ?>
<div class="mt-service-accordion ver_2 career_accordion headline">
    <div class="accordion" id="accordionExample_<?php echo esc_attr($rand); ?>">
        <?php
            foreach ( $settings['faq_lists'] as $id => $list ):
            $is_active = $list['is_active'] == 'yes' ? 'faq_active' : '';
            $show = $list['is_active'] == 'yes' ? 'show' : '';
            $aria_expanded = $list['is_active'] == 'yes' ? 'true' : 'false';
            $collapsed = $list['is_active'] == 'yes' ? '' : 'collapsed';
        ?>
        <div class="accordion-item wow fadeInUp"  data-wow-delay="200ms" data-wow-duration="1000ms">
            <h2 class="accordion-header" id="heading-<?php echo esc_attr($rand . '-' . $id); ?>">
                <button class="accordion-button <?php echo esc_attr($collapsed); ?>"
                type="button"
                data-bs-toggle="collapse"
                data-bs-target="#collapse-<?php echo esc_attr($rand . '-' . $id); ?>"
                aria-expanded="<?php echo esc_attr($aria_expanded); ?>"
                aria-controls="collapse-<?php echo esc_attr($rand . '-' . $id); ?>">
                    <span><?php echo elh_element_kses_intermediate($list['title']); ?></span>
                </button>
            </h2>
            <div id="collapse-<?php echo esc_attr($rand . '-' . $id); ?>"
            class="accordion-collapse collapse <?php echo esc_attr($show); ?>"
            aria-labelledby="heading-<?php echo esc_attr($rand . '-' . $id); ?>"
            data-bs-parent="#accordionExample_<?php echo esc_attr($rand); ?>">
                <div class="accordion-body">
                    <div class="career-open headline pera-content">
                        <div class="info-meta d-flex align-items-center justify-content-between flex-wrap">
                            <div class="info-item">
                                <?php if(!empty( $list['location_label'] )) : ?>
                                <h4><?php echo elh_element_kses_intermediate($list['location_label']); ?></h4>
                                <?php endif; ?>
                                <?php if(!empty( $list['location'] )) : ?>
                                <span>
                                    <?php echo elh_element_kses_intermediate($list['location']); ?>
                                </span>
                                <?php endif; ?>
                            </div>
                            <div class="info-item">
                                <?php if(!empty( $list['experience_label'] )) : ?>
                                <h4>
                                    <?php echo elh_element_kses_intermediate($list['experience_label']); ?>
                                </h4>
                                <?php endif; ?>

                                <?php if(!empty( $list['experience'] )) : ?>
                                <span>
                                    <?php echo elh_element_kses_intermediate($list['experience']); ?>
                                </span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="info-meta">
                            <div class="info-item">
                                <?php if(!empty( $list['required_skills_label'] )) : ?>
                                <h4>
                                    <?php echo elh_element_kses_intermediate($list['required_skills_label']); ?>
                                </h4>
                                <?php endif; ?>

                                <?php if(!empty( $list['required_skills'] )) : ?>
                                <span><?php echo elh_element_kses_intermediate($list['required_skills']); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php if(!empty( $list['content'] )) : ?>
                    <p><?php echo elh_element_kses_intermediate($list['content']); ?></p>
                    <?php endif; ?>
                    <a class="open_btn text-uppercase" href="#">apply now <i class="fa-solid fa-arrow-right"></i></a>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</div>