<?php $rand = rand( 1, 1000 ); ?>
<div class="mt-faq-accordion-3">
    <div class="mt-faq-title">
        <?php if( $settings['enable_sub_title'] === 'yes' ) : ?>
        <span><?php echo elh_element_kses_intermediate( $settings['sub_title'] ); ?></span>
        <?php endif; ?>

        <?php
            if($settings['enable_title'] === 'yes') {
            $this->add_render_attribute( 'title', 'class', 'tx-title sec_title title_text title_text_ani' );
                printf('<%1$s %2$s>%3$s</%1$s>',
                    tag_escape($settings['title_tag']),
                    $this->get_render_attribute_string('title'),
                    elh_element_kses_basic( $settings['title'] )
                );
            }
        ?>
    </div>
    <div class="accordion" id="accordionExample_<?php echo esc_attr($rand); ?>">
        <?php
            foreach ( $settings['faq_lists'] as $id => $list ):
            $is_active = $list['is_active'] == 'yes' ? 'faq_active' : '';
            $show = $list['is_active'] == 'yes' ? 'show' : '';
            $aria_expanded = $list['is_active'] == 'yes' ? 'true' : 'false';
            $collapsed = $list['is_active'] == 'yes' ? '' : 'collapsed';
        ?>
        <div class="accordion-item wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1000ms">
            <h2 class="accordion-header" id="heading-<?php echo esc_attr($rand . '-' . $id); ?>">
                <button class="accordion-button <?php echo esc_attr($collapsed); ?>"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse-<?php echo esc_attr($rand . '-' . $id); ?>"
                    aria-expanded="<?php echo esc_attr($aria_expanded); ?>"
                    aria-controls="collapse-<?php echo esc_attr($rand . '-' . $id); ?>">
                    <span><?php echo elh_element_kses_intermediate($list['title']); ?></span>
                </button>
            </h2>
            <div id="collapse-<?php echo esc_attr($rand . '-' . $id); ?>"
                class="accordion-collapse collapse <?php echo esc_attr($show); ?>"
                aria-labelledby="heading-<?php echo esc_attr($rand . '-' . $id); ?>"
                data-bs-parent="#accordionExample_<?php echo esc_attr($rand); ?>">
                <div class="accordion-body ">
                    <div class="bi-faq-text pera-content">
                        <?php echo elh_element_kses_intermediate($list['content']); ?>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</div>