<?php $rand = rand( 1, 1000 ); ?>
<section class="mt-service-section txt_item_active pt-90 pb-85 position-relative tx-section">
    <?php if(!empty( $settings['image_1']['url'] )) : ?>
    <span class="mt-service-shape position-absolute">
        <img src="<?php echo esc_url($settings['image_1']['url']); ?>"
        alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_1']['url']) : ''); ?>">
    </span>
    <?php endif; ?>

    <?php if(!empty( $settings['image_2']['url'] )) : ?>
    <span class="mt-service-shape-2 position-absolute">
        <img src="<?php echo esc_url($settings['image_2']['url']); ?>"
        alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_2']['url']) : ''); ?>">
    </span>
    <?php endif; ?>

    <div class="mt-service-cta d-flex align-items-center position-absolute wow fadeInRight"  data-wow-delay="400ms" data-wow-duration="1000ms">
        <?php if(!empty( $settings['contact_info_icon'] )) : ?>
        <div class="item-icon d-flex justify-content-center align-items-center">
            <?php \Elementor\Icons_Manager::render_icon( $settings['contact_info_icon'], ['aria-hidden' => 'true'] ); ?>
        </div>
        <?php endif; ?>
        <div class="item-text">
            <?php if(!empty( $settings['contact_info_label'] )) : ?>
            <span><?php echo elh_element_kses_intermediate( $settings['contact_info_label'] ); ?></span>
            <?php endif; ?>
            <?php echo wp_kses($settings['contact_info_text'], true); ?>
        </div>
    </div>

    <div class="container mt-container-1">
        <div class="mt-service-content d-flex">
            <div class="mt-service-text-area">
                <div class="mt-section-title mt-text  headline pera-content">
                    <?php if( $settings['enable_sub_title'] === 'yes' ) : ?>
                    <div class="subtitle wow fadeInRight"  data-wow-delay="400ms" data-wow-duration="1000ms">
                        <?php echo elh_element_kses_intermediate( $settings['sub_title'] ); ?>
                    </div>
                    <?php
                    endif;
                        if($settings['enable_title'] === 'yes') {
                        $this->add_render_attribute( 'title', 'class', 'tx-title sec_title title_text title_text_ani' );
                            printf('<%1$s %2$s>%3$s</%1$s>',
                                tag_escape($settings['title_tag']),
                                $this->get_render_attribute_string('title'),
                                elh_element_kses_basic( $settings['title'] )
                            );
                        }
                    if( $settings['enable_description'] === 'yes' ) : ?>
                    <p class="tx-description"><?php echo elh_element_kses_intermediate($settings['description']); ?></p>
                    <?php endif; ?>
                </div>

                <div class="mt-btn-3 ver_3 text-uppercase wow fadeInUp"  data-wow-delay="500ms" data-wow-duration="1000ms">
                <a href="<?php echo esc_url($settings['button_link']['url']); ?>"
                target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                rel= "<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>"
                aria-label="name" class="pf-pr-2 tx-button">
                    <?php echo esc_attr( $settings['button_text'] ); ?> <i class="fas fa-arrow-right"></i></a>
                </div>
            </div>
            <div class="mt-service-accordion headline">
                <?php if(!empty( $settings['faq_heading'] )) : ?>
                <h3><?php echo elh_element_kses_intermediate($settings['faq_heading']); ?></h3>
                <?php endif; ?>
                <div class="accordion" id="accordionExample_<?php echo esc_attr($rand); ?>">
                    <?php
                        foreach ( $settings['faq_lists'] as $id => $list ):
                        $is_active = $list['is_active'] == 'yes' ? 'faq_active' : '';
                        $show = $list['is_active'] == 'yes' ? 'show' : '';
                        $aria_expanded = $list['is_active'] == 'yes' ? 'true' : 'false';
                        $collapsed = $list['is_active'] == 'yes' ? '' : 'collapsed';
                    ?>
                    <div class="accordion-item wow fadeInUp"  data-wow-delay="200ms" data-wow-duration="1000ms">
                        <h2 class="accordion-header" id="heading-<?php echo esc_attr($rand . '-' . $id); ?>">
                            <button class="accordion-button <?php echo esc_attr($collapsed); ?>"
                            type="button"
                            data-bs-toggle="collapse"
                            data-bs-target="#collapse-<?php echo esc_attr($rand . '-' . $id); ?>"
                            aria-expanded="<?php echo esc_attr($aria_expanded); ?>"
                            aria-controls="collapse-<?php echo esc_attr($rand . '-' . $id); ?>">
                                <span><?php echo elh_element_kses_intermediate($list['title']); ?></span>
                            </button>
                        </h2>
                        <div id="collapse-<?php echo esc_attr($rand . '-' . $id); ?>"
                        class="accordion-collapse collapse <?php echo esc_attr($show); ?>"
                        aria-labelledby="heading-<?php echo esc_attr($rand . '-' . $id); ?>"
                        data-bs-parent="#accordionExample_<?php echo esc_attr($rand); ?>">
                            <div class="accordion-body ">
                                <div class="bi-faq-text pera-content">
                                    <p><?php echo elh_element_kses_intermediate($list['content']); ?></p>
                                    <a href="<?php echo esc_url($list['button_link']['url']); ?>"
                                    target="<?php echo esc_attr($list['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                                    rel="<?php echo esc_attr($list['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                                        <?php echo esc_html($list['button_text']); ?>
                                        <?php \Elementor\Icons_Manager::render_icon( $list['button_icon'], ['aria-hidden' => 'true'] ); ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>