<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;


// faq content style
$this->start_controls_section(
    '_section_style_faq_content',
    [
        'label' => __( 'Faq Content', 'mojito-core' ),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

// faq text color
$this->add_control(
    'faq_text_color',
    [
        'label'     => __( 'Text Color', 'mojito-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .pf-accordion-item .item-body p' => 'color: {{VALUE}};',
        ],
    ]
);

// typography
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'     => 'faq_typography',
        'label'    => __( 'Typography', 'mojito-core' ),
        'selector' => '{{WRAPPER}} .pf-accordion-item .item-body p',
    ]
);
$this->add_control(
    'left_icon_heading',
    [
        'label'     => esc_html__( 'Left Icon BG Color', 'Text-domain' ),
        'type'      => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
    ]
);

// left icon bg
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'faq_left_icon_bg',
        'label'    => __( 'Left Icon Background', 'mojito-core' ),
        'types'    => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .chy-sd-1-item .accordion-item .accordion-header .accordion-button .icon-2',
    ]
);

// left icon color
$this->add_control(
    'faq_left_icon_color',
    [
        'label'     => __( 'Left Icon Color', 'mojito-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-sd-1-item .accordion-item .accordion-header .accordion-button .icon-2' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'right_icon_heading',
    [
        'label'     => esc_html__( 'Right Icon BG Color', 'Text-domain' ),
        'type'      => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
    ]
);

// right icon bg
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'faq_right_icon_bg',
        'label'    => __( 'Right Icon Background', 'mojito-core' ),
        'types'    => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .chy-sd-1-item .accordion-item .accordion-header .accordion-button:is(:not(.collapsed)) .icon',
    ]
);

// right icon color
$this->add_control(
    'faq_right_icon_color',
    [
        'label'     => __( 'Right Icon Color', 'mojito-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-sd-1-item .accordion-item .accordion-header .accordion-button:is(:not(.collapsed)) .icon' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'title_heading',
    [
        'label'     => esc_html__( 'Title Color', 'Text-domain' ),
        'type'      => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
    ]
);

// title color
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'title_color',
        'label'    => __( 'Title Color', 'mojito-core' ),
        'types'    => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .chy-sd-1-item .accordion-item .accordion-header .accordion-button:is(:not(.collapsed)) .title',
    ]
);

// end
$this->end_controls_section();