<section class="mt-contact-section tx-section"
data-background="<?php echo esc_url($settings['image_1']['url']) ? esc_url($settings['image_1']['url']) : ''; ?>">
    <div class="container mt-container-1">
        <div class="mt-contact-content d-flex">
            <div class="mt-contact-form" data-background="<?php echo esc_url($settings['image_2']['url']) ? esc_url($settings['image_2']['url']) : ''; ?>">
                <div class="mt-section-title headline pera-content">
                    <?php if(!empty( $settings['contact_subtitle'] )) : ?>
                    <div class="subtitle">
                        <?php echo elh_element_kses_intermediate($settings['contact_subtitle']); ?>
                    </div>
                    <?php endif; ?>

                    <?php if(!empty( $settings['contact_title'] )) : ?>
                    <h2 class="sec_title"><?php echo elh_element_kses_intermediate($settings['contact_title']); ?></h2>
                    <?php endif; ?>
                </div>

                <?php if( $settings['enable_contact_form'] === 'yes' ) : ?>
                <div class="tx-contact-form">
                    <?php echo do_shortcode( $settings['contact_form_shortcode'] ); ?>
                </div>
                <?php endif; ?>

                <?php if( $settings['enable_video_box'] === 'yes' ) : ?>
                <div class="mt-contact-play mt-45 d-flex  align-items-center flex-wrap">
                    <?php if(!empty( $settings['video_box_link']['url'] )) : ?>
                    <div class="play-icon">
                        <a  href="<?php echo esc_url($settings['video_box_link']['url']); ?>" data-background="<?php echo esc_url($settings['video_box_image']['url']) ? esc_url($settings['video_box_image']['url']) : ''; ?>"><i class="fas fa-play"></i></a>
                    </div>
                    <?php endif; ?>

                    <div class="play-text headline pera-content">
                        <?php if(!empty( $settings['video_box_sub_title'] )) : ?>
                        <h3><?php echo elh_element_kses_intermediate( $settings['video_box_sub_title'] ); ?></h3>
                        <?php endif; ?>

                        <?php if(!empty( $settings['video_box_title'] )) : ?>
                        <p><?php echo elh_element_kses_intermediate( $settings['video_box_title'] ); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            <div class="mt-contact-text">
                <div class="mt-section-title headline pera-content">
                    <?php if( $settings['enable_sub_title'] === 'yes' ) : ?>
                    <div class="subtitle"><?php echo elh_element_kses_intermediate( $settings['sub_title'] ); ?></div>
                    <?php
                    endif;
                        if($settings['enable_title'] === 'yes') {
                        $this->add_render_attribute( 'title', 'class', 'tx-title sec_title' );
                            printf('<%1$s %2$s>%3$s</%1$s>',
                                tag_escape($settings['title_tag']),
                                $this->get_render_attribute_string('title'),
                                elh_element_kses_basic( $settings['title'] )
                            );
                        }
                    if( $settings['enable_description'] === 'yes' ) : ?>
                    <p class="tx-description"><?php echo elh_element_kses_intermediate($settings['description']); ?></p>
                    <?php endif; ?>
                </div>

                <?php if( $settings['enable_count_box'] === 'yes' ) : ?>
                <div class="contact-number headline position-relative">
                    <h3><span class="counter"><?php echo esc_html($settings['count_number']); ?></span><?php echo esc_html($settings['count_prefix']); ?></h3>
                    <?php if(!empty( $settings['count_title'] )) : ?>
                    <p>
                        <?php echo esc_html($settings['count_title']); ?>
                    </p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>