<div class="mt-footer-widget-4">
    <div class="logo-widget">
        <div class="logo-cta">
            <?php if( $settings['enable_contact_info'] === 'yes' ) :
                foreach( $settings['list_items'] as $list ) :
                if($list['link_type'] === 'email') {
                    $info_label = 'mailto:' . $list['info_label'];
                } elseif( $list['link_type'] === 'phone' ) {
                    $info_label = 'tel:' . $list['info_label'];
                } else {
                    $info_label = $list['info_label'];
                }
                if($list['enable_link'] === 'yes') {
                    $info_label = $list['info_link'];
                }
            ?>
            <div class="cta-info d-flex align-items-center">
                <?php if( $list['enable_icon'] === 'yes' ) : ?>
                <div class="info-icon d-flex justify-content-center align-items-center">
                    <?php if( $list['type'] === 'icon' ) : ?>
                        <?php \Elementor\Icons_Manager::render_icon( $list['list_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    <?php else : ?>
                        <img src="<?php echo esc_url( $list['list_image']['url'] ); ?>" alt="<?php echo esc_attr( $list['list_image']['alt'] ); ?>">
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                <div class="info-text">
                    <?php if( $list['enable_link'] === 'yes' ) : ?>
                    <a href="<?php echo $info_label; ?>" class="link"><?php echo esc_html( $list['info_label'] ); ?></a>
                    <?php else : ?>
                    <span>
                        <?php echo esc_html( $list['info_label'] ); ?>
                    </span>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; endif; ?>
        </div>
    </div>
</div>