<div class="art-career-apply-info ul-li-block">
    <?php if( $settings['enable_job_info'] === 'yes' ) : ?>
    <ul class="list-unstyled">
        <?php foreach($settings['job_infos'] as $list) : ?>
        <li>
            <?php if(!empty( $list['info_label'] )) : ?>
            <span class="v-tilte">
                <?php \Elementor\Icons_Manager::render_icon( $list['info_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                <?php echo esc_html($list['info_label']); ?>
            </span>
            <?php endif; ?>
            
            <?php if(!empty( $list['job_info'] )) : ?>
            <span class="v-value">
                <?php echo esc_html($list['job_info']); ?>
            </span>
            <?php endif; ?>
        </li>
        <?php endforeach; ?>
    </ul>
    <?php endif; ?>

    <?php if(!empty( $settings['button_text'] )) : ?>
    <a href="<?php echo esc_url( $settings['button_link']['url'] ); ?>"
        target="<?php echo esc_attr( $settings['button_link']['is_external'] ? '_blank' : '_self' ); ?>"
        rel="<?php echo esc_attr( $settings['button_link']['nofollow'] ? 'nofollow' : '' ); ?>"
        aria-label="name" class="text-uppercase text-center tx-button">
        <?php echo esc_html($settings['button_text']); ?>
    </a>
    <?php endif; ?>
</div>