<?php
namespace ElementHelper\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;

defined( 'ABSPATH' ) || die();

class Tx_Career_Box extends Element_El_Widget {

    /**
     * Get widget name.
     *
     * Retrieve Mojito Core widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'tx_career_box';
    }

    /**
     * Get widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Tx Career Box', 'mojito-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/icon-box/';
    }

    /**
     * Get widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-preview-medium';
    }

    public function get_keywords() {
        return ['career', 'job'];
    }

    protected function register_content_controls() {

        $this->start_controls_section(
            '_section_design_title',
            [
                'label' => __( 'Design Style', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'mojito-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'mojito-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();

        // SERVICES
        $this->start_controls_section(
            '_section_info_box',
            [
                'label' => __( 'Info Box', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // button text
        $this->add_control(
            'button_text',
            [
                'label'       => __( 'Button Text', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __( 'Read More', 'mojito-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        // button_link
        $this->add_control(
            'button_link',
            [
                'label'       => __( 'Button Link', 'mojito-core' ),
                'type'        => Controls_Manager::URL,
                'label_block' => true,
                'default'     => [
                    'url' => '#',
                ],
                'placeholder' => __( 'https://your-link.com', 'mojito-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        // enable job info
        $this->add_control(
            'enable_job_info',
            [
                'label'        => __( 'Enable Job Info', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'mojito-core' ),
                'label_off'    => __( 'No', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // repeater
        $repeater = new Repeater();

        // design style
        $repeater->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'mojito-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'mojito-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        // info icon
        $repeater->add_control(
            'info_icon',
            [
                'label'       => __( 'Info Icon', 'mojito-core' ),
                'type'        => Controls_Manager::ICONS,
                'label_block' => true,
                'default'     => [
                    'value'   => 'fas fa-check',
                    'library' => 'solid',
                ],
            ]
        );

        // info label
        $repeater->add_control(
            'info_label',
            [
                'label'       => __( 'Info Label', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __( 'Info Label', 'mojito-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        // job infos
        $repeater->add_control(
            'job_info',
            [
                'label'       => __( 'Job Info', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __( 'Job Info', 'mojito-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        // repeater end
        $this->add_control(
            'job_infos',
            [
                'label'       => __( 'Job Infos', 'mojito-core' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'job_info' => __( 'Job Info', 'mojito-core' ),
                    ],
                ],
                'title_field' => '{{{ job_info }}}',
                'condition'   => [
                    'enable_job_info' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function register_style_controls() {
        // title style
        $this->start_controls_section(
            '_section_style_title',
            [
                'label' => __( 'Info Box Style', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        // background control field and exclude video
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'background',
                'label'    => __( 'Background', 'mojito-core' ),
                'types'    => ['classic', 'gradient'],
                'exclude'  => [
                    'image',
                    'video',
                ],
                'selector' => '{{WRAPPER}} .tx-serviceBox',
            ]
        );

        // title color
        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'mojito-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-block_three-heading a' => 'color: {{VALUE}};',
                ],
            ]
        );

        // typography
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => __( 'Typography', 'mojito-core' ),
                'selector' => '{{WRAPPER}} .service-block_three-heading a',
            ]
        );

        // description color
        $this->add_control(
            'description_color',
            [
                'label'     => __( 'Description Color', 'mojito-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-block_three-text' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'design_style' => ['style_1', 'style_3'],
                ],
            ]
        );

        // description typography
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'description_typography',
                'label'     => __( 'Typography', 'mojito-core' ),
                'selector'  => '{{WRAPPER}} .service-block_three-text',
                'condition' => [
                    'design_style' => ['style_1', 'style_3'],
                ],
            ]
        );

        // button color
        $this->add_control(
            'button_color',
            [
                'label'     => __( 'Button Color', 'mojito-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-block_three-more' => 'color: {{VALUE}};',
                ],
            ]
        );

        // button typography
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'button_typography',
                'label'    => __( 'Typography', 'mojito-core' ),
                'selector' => '{{WRAPPER}} .service-block_three-more',
            ]
        );

        // end
        $this->end_controls_section();
    }

    /**
     * Render widget output on the frontend.
     *
     * Used to generate the final HTML displayed on the frontend.
     *
     * Note that if skin is selected, it will be rendered by the skin itself,
     * not the widget.
     *
     * @since 1.0.0
     * @access public
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        $style = !empty( $settings['design_style'] ) ? $settings['design_style'] : 'style_1';

        switch ( $style ) {
        case 'style_2':
            include $dir . '/views/view-2.php';
            break;
        default:
            include $dir . '/views/view-1.php';
        }
    }

}