<section class="mt-ser-why-choose-section position-relative pt-110 pb-110 tx-section">
    <?php if(!empty( $settings['image_1']['url'] )) : ?>
    <div class="mt-ser-why-choose-img position-absolute">
        <img src="<?php echo esc_url($settings['image_1']['url']); ?>" alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_1']['url']) : ''); ?>">
    </div>
    <?php endif; ?>

    <div class="container mt-container-1">
        <div class="mt-ser-why-choose-content d-flex">
            <div class="mt-ser-why-choose-text headline pera-content">
                <div class="mt-section-title  headline pera-content">
                    <?php if( $settings['enable_sub_title'] === 'yes' ) : ?>
                    <div class="subtitle  wow fadeInRight"  data-wow-delay="400ms" data-wow-duration="1000ms">
                        <?php echo elh_element_kses_intermediate($settings['sub_title']); ?>
                    </div>
                    <?php endif; ?>
                    <?php
                        if($settings['enable_title'] === 'yes') {
                        $this->add_render_attribute( 'title', 'class', 'tx-title sec_title title_text title_text_ani' );
                            printf('<%1$s %2$s>%3$s</%1$s>',
                                tag_escape($settings['title_tag']),
                                $this->get_render_attribute_string('title'),
                                elh_element_kses_basic( $settings['title'] )
                            );
                        }
                    ?>
                    <?php if( $settings['enable_description'] === 'yes' ) : ?>
                    <p><?php echo elh_element_kses_intermediate($settings['description']); ?></p>
                    <?php endif; ?>
                </div>

                <?php if( $settings['enable_feature_lists'] === 'yes' ) : ?>
                <div class="mt-ser-why-choose-steps position-relative mt-50">
                    <?php foreach($settings['feature_lists'] as $list ) : ?>
                    <div class="steps-item-wrap d-flex">
                        <?php if(!empty( $list['feature_count'] )) : ?>
                        <div class="item-serial d-flex align-items-center justify-content-center">
                            <?php echo esc_html($list['feature_count']); ?>
                        </div>
                        <?php endif; ?>
                        <div class="item-text headline pera-content">
                            <?php if(!empty( $list['feature_title'] )) : ?>
                            <h3><?php echo elh_element_kses_intermediate( $list['feature_title'] ); ?></h3>
                            <?php endif; ?>

                            <?php if(!empty( $list['feature_description'] )) : ?>
                            <p><?php echo elh_element_kses_intermediate( $list['feature_description'] ); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>