<section class="mt-why-choose-section-4 pt-160 tx-section">
    <div class="container mt-container-1">
        <div class="mt-why-choose-content-4 d-flex">
            <?php if(!empty( $settings['image_1']['url'] )) : ?>
            <div class="mt-why-choose-img-4 appear_top">
                <div class="item-img">
                    <img src="<?php echo esc_url($settings['image_1']['url']); ?>"
                alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_1']['url']) : ''); ?>">
                </div>
            </div>
            <?php endif; ?>
            <div class="mt-why-choose-text-4">
                <div class="mt-section-title headline pera-content">
                    <?php if( $settings['enable_sub_title'] === 'yes' ) : ?>
                    <div class="subtitle-2">
                        <?php echo elh_element_kses_intermediate($settings['sub_title']); ?>
                    </div>
                    <?php endif; ?>

                    <?php
                        if($settings['enable_title'] === 'yes') {
                        $this->add_render_attribute( 'title', 'class', 'tx-title sec_title' );
                            printf('<%1$s %2$s>%3$s</%1$s>',
                                tag_escape($settings['title_tag']),
                                $this->get_render_attribute_string('title'),
                                elh_element_kses_basic( $settings['title'] )
                            );
                        }
                    ?>
                    <?php if( $settings['enable_description'] === 'yes' ) : ?>
                    <p><?php echo elh_element_kses_intermediate($settings['description']); ?></p>
                    <?php endif; ?>
                </div>

                <div class="mt-why-choose-progress-text  mt-45 d-flex flex-wrap">
                    <div class="mt-why-choose-progress position-relative">
                        <div class="mt-wc-progress-item-wrap txt_item_active d-flex align-items-end">

                            <div class="mt-wc-progress-item-wrap txt_item_active d-flex align-items-end">
								<div class="mt-wc-progress-item text-uppercase">
									<span>26k</span>
								</div>
								<div class="mt-wc-progress-item text-uppercase">
									<span>50k</span>
								</div>
								<div class="mt-wc-progress-item text-uppercase">
									<span>90k</span>
								</div>
							</div>

                        </div>
                        <?php if(!empty( $settings['image_2']['url'] )) : ?>
                        <div class="mt-search-shape">
                            <img src="<?php echo esc_url($settings['image_2']['url']); ?>"
                        alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_2']['url']) : ''); ?>">
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="mt-wc-text-area-4 wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1000ms">
                        <div class="item-text headline ">
                            <?php if(!empty( $settings['info_text_title'] )) : ?>
                            <span><?php echo elh_element_kses_intermediate($settings['info_text_title']); ?></span>
                            <?php endif; ?>

                            <?php if(!empty( $settings['info_text_title_2'] )) : ?>
                            <h3><?php echo elh_element_kses_intermediate($settings['info_text_title_2']); ?></h3>
                            <?php endif; ?>
                        </div>

                        <?php if( $settings['enable_info_feature_lists'] === 'yes' ) : ?>
                        <div class="item-list ul-li-block">
                            <ul>
                                <?php if( $settings['enable_info_feature_lists'] === 'yes' ) :
                                    $list_items = explode("\n", $settings['info_feature_lists']);
                                    foreach ($list_items as $list): ?>
                                <li>
                                    <?php \Elementor\Icons_Manager::render_icon( $settings['info_feature_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    <?php echo wp_kses($list, true)?>
                                </li>
                                <?php endforeach; ?>
                            <?php endif; ?>

                            </ul>
                        </div>
                        <?php endif; ?>

                        <?php if( $settings['enable_button'] === 'yes' ) : ?>
                        <div class="mt-btn-3 text-uppercase wow fadeInUp"  data-wow-delay="500ms" data-wow-duration="1000ms">
                             <a class="tx-button" href="<?php echo esc_url($settings['button_link']['url']); ?>"
                            target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                            rel="<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                                <?php echo esc_html($settings['button_text']); ?>
                                <?php
                                    if(!empty( $settings['enable_button_icon'] === 'yes') ) {
                                        \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] );
                                    }
                                ?>
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>