<section class="mt-about-section-4 pb-50 tx-section">
    <div class="container mt-container-1">
        <div class="mt-about-content-4 d-flex">
            <div class="mt-about-text-4">
                <div class="mt-section-title ver_2 headline">
                    <?php if( $settings['enable_sub_title'] === 'yes' ) : ?>
                    <div class="subtitle-2 wow fadeInRight"  data-wow-delay="300ms" data-wow-duration="1000ms">
                        <?php echo elh_element_kses_intermediate($settings['sub_title']); ?>
                    </div>
                    <?php endif; ?>

                    <?php
                        if($settings['enable_title'] === 'yes') {
                        $this->add_render_attribute( 'title', 'class', 'tx-title sec_title title_text title_text_ani' );
                            printf('<%1$s %2$s>%3$s</%1$s>',
                                tag_escape($settings['title_tag']),
                                $this->get_render_attribute_string('title'),
                                elh_element_kses_basic( $settings['title'] )
                            );
                        }
                    ?>
                </div>
                <div class="mt-about-img-4 pt-75">
                    <div class="inner-img txt_item_active d-flex">
                        <?php if(!empty( $settings['image_1']['url'] )) : ?>
                        <div class="item-img-1 item-img">
                            <img src="<?php echo esc_url($settings['image_1']['url']); ?>"
                        alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_1']['url']) : ''); ?>">
                        </div>
                        <?php endif; ?>

                        <?php if(!empty( $settings['image_2']['url'] )) : ?>
                        <div class="item-img-2 item-img">
                            <img src="<?php echo esc_url($settings['image_2']['url']); ?>"
                        alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_2']['url']) : ''); ?>">
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="mt-about-counter">
                <div  class="desc-text mt-text pera-content">
                    <?php if( $settings['enable_description'] === 'yes' ) : ?>
                    <p><?php echo elh_element_kses_intermediate($settings['description']); ?></p>
                    <?php endif; ?>
                </div>

                <?php if( $settings['enable_count_box'] === 'yes' ) : ?>
                <div class="mt-item-counter d-flex justify-content-between wow fadeInUp"  data-wow-delay="300ms" data-wow-duration="1000ms">
                    <?php foreach($settings['count_box_lists'] as $list) : ?>
                    <div class="item-counter headline pera-content">
                        <h3><?php echo esc_html($list['count_suffix']); ?><span class="counter"><?php echo esc_html($list['count_number']); ?></span><?php echo esc_html($list['count_prefix']); ?></h3>
                        <p>
                            <?php echo elh_element_kses_intermediate($list['count_title']); ?>
                        </p>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>

                <div class="mt-about-list-area ul-li-block d-flex mt-15 wow fadeInUp"  data-wow-delay="400ms" data-wow-duration="1000ms">
                    <div class="item-list">
                        <?php if( $settings['enable_info_feature_lists'] === 'yes' ) :
                            $list_items = explode("\n", $settings['info_feature_lists']);
                        ?>
                        <ul>
                            <?php foreach ($list_items as $list): ?>
                            <li><?php echo wp_kses($list, true)?></li>
                            <?php endforeach; ?>
                        </ul>
                        <?php endif; ?>

                        <?php if( $settings['enable_button'] === 'yes' ) : ?>
                        <div class="mt-btn-3 mt-35 ver_3 text-uppercase">
                            <a class="tx-button" href="<?php echo esc_url($settings['button_link']['url']); ?>"
                            target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                            rel="<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                                <?php echo esc_html($settings['button_text']); ?>
                                <?php
                                    if(!empty( $settings['enable_button_icon'] === 'yes') ) {
                                        \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] );
                                    }
                                ?>
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>