<section class="mt-about-section-3 pb-120">
    <div class="container mt-container-1">
        <div class="mt-about-content-3 d-flex">
            <div class="mt-about-text-3">
                <div class="mt-section-title mt-text ver_2 headline pera-content">
                    <?php if( $settings['enable_sub_title'] === 'yes' ) : ?>
                    <div class="subtitle-2 wow fadeInRight"  data-wow-delay="400ms" data-wow-duration="1000ms">
                        <?php echo elh_element_kses_intermediate($settings['sub_title']); ?>
                    </div>
                    <?php endif; ?>
                    <?php
                        if($settings['enable_title'] === 'yes') {
                        $this->add_render_attribute( 'title', 'class', 'tx-title sec_title title_text title_text_ani' );
                            printf('<%1$s %2$s>%3$s</%1$s>',
                                tag_escape($settings['title_tag']),
                                $this->get_render_attribute_string('title'),
                                elh_element_kses_basic( $settings['title'] )
                            );
                        }
                    ?>
                    <?php if( $settings['enable_description'] === 'yes' ) : ?>
                    <p><?php echo elh_element_kses_intermediate($settings['description']); ?></p>
                    <?php endif; ?>
                </div>
                <div class="mt-about-list-area ul-li-block d-flex mt-40  wow fadeInUp"  data-wow-delay="400ms" data-wow-duration="1000ms">
                    <div class="item-list">

                        <?php if( $settings['enable_info_feature_lists'] === 'yes' ) :
                            $list_items = explode("\n", $settings['info_feature_lists']);
                        ?>
                        <ul>
                            <?php foreach ($list_items as $list): ?>
                            <li><?php echo wp_kses($list, true)?></li>
                            <?php endforeach; ?>
                        </ul>
                        <?php endif; ?>

                        <?php if( $settings['enable_button'] === 'yes' ) : ?>
                        <div class="mt-btn-3 mt-35 ver_2 text-uppercase">
                            <a class="tx-button" href="<?php echo esc_url($settings['button_link']['url']); ?>"
                            target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                            rel="<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                                <?php echo esc_html($settings['button_text']); ?>
                                <?php
                                    if(!empty( $settings['enable_button_icon'] === 'yes') ) {
                                        \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] );
                                    }
                                ?>
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>

                    <?php if( $settings['enable_count_box'] === 'yes' ) : ?>
                    <div class="mt-about-exp headline pera-content d-flex align-items-center justify-content-center">
                        <div class="item-text">
                            <h3>
                                <span class="counter"><?php echo esc_html($settings['count_number']); ?></span><?php echo esc_html($settings['count_prefix']); ?></h3>
                            <?php if(!empty( $settings['count_title'] )) : ?>
                            <p><?php echo esc_html($settings['count_title']); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="mt-about-img-wrap-3 txt_item_active position-relative">
                <?php if(!empty( $settings['image_1']['url'] )) : ?>
                <div class="item-img-2 position-absolute">
                    <img src="<?php echo esc_url($settings['image_1']['url']); ?>"
                    alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_1']['url']) : ''); ?>">
                </div>
                <?php endif; ?>

                <?php if(!empty( $settings['image_2']['url'] )) : ?>
                <div class="item-img-3 position-absolute">
                    <img src="<?php echo esc_url($settings['image_2']['url']); ?>"
                    alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_2']['url']) : ''); ?>">
                </div>
                <?php endif; ?>

                <?php if(!empty( $settings['image_3']['url'] )) : ?>
                <div class="item-img-1">
                    <img src="<?php echo esc_url($settings['image_3']['url']); ?>"
                    alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_3']['url']) : ''); ?>">
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>