<section class="mt-why-choose-section-2 position-relative pt-130 pb-130 tx-section" data-background="<?php echo esc_url($settings['image_1']['url']) ? esc_url($settings['image_1']['url']) : ''; ?>">
    <?php if(!empty( $settings['image_2']['url'] )) : ?>
    <span class="mt-why-choose-img appear_left_1 position-absolute">
        <img src="<?php echo esc_url($settings['image_2']['url']); ?>"
        alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_2']['url']) : ''); ?>">
    </span>
    <?php endif; ?>

    <?php if(!empty( $settings['image_3']['url'] )) : ?>
    <span class="mt-why-choose-shape appear_left_2 position-absolute">
        <img src="<?php echo esc_url($settings['image_3']['url']); ?>"
        alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_3']['url']) : ''); ?>">
    </span>
    <?php endif; ?>

    <div class="container mt-container-1">
        <div class="mt-why-choose-content-2 justify-content-end d-flex">
            <div class="mt-why-choose-wrap-2 d-flex">
                <?php if(!empty( $settings['image_4']['url'] )) : ?>
                <div class="item-main-img appear_top">
                    <img src="<?php echo esc_url($settings['image_4']['url']); ?>"
                    alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_4']['url']) : ''); ?>">
                </div>
                <?php endif; ?>
                <div class="item-text">
                    <div class="mt-section-title ver_2 headline">
                        <?php if(!empty( $settings['sub_title'] )) : ?>
                        <div class="subtitle-2">
                            <span><?php echo elh_element_kses_intermediate($settings['sub_title']); ?></span>
                        </div>
                        <?php endif; ?>

                        <?php
                            if($settings['enable_title'] === 'yes') {
                            $this->add_render_attribute( 'title', 'class', 'tx-title sec_title title_text title_text_ani' );
                                printf('<%1$s %2$s>%3$s</%1$s>',
                                    tag_escape($settings['title_tag']),
                                    $this->get_render_attribute_string('title'),
                                    elh_element_kses_basic( $settings['title'] )
                                );
                            }
                        ?>
                    </div>

                    <?php if( $settings['enable_button'] === 'yes' ) : ?>
                    <div class="mt-btn-3 mt-25 ver_2 text-uppercase">
                        <a class="tx-button" href="<?php echo esc_url($settings['button_link']['url']); ?>"
                        target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                        rel="<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                            <?php echo esc_html($settings['button_text']); ?>
                            <?php
                                if(!empty( $settings['enable_button_icon'] === 'yes') ) {
                                    \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] );
                                }
                            ?>
                        </a>
                    </div>
                    <?php endif; ?>

                    <?php if( $settings['enable_feature_lists'] === 'yes' ) : ?>
                    <div class="item-wc-feature ul-li-block mt-50">
                        <ul>
                            <?php foreach($settings['feature_lists'] as $list ) :
                                $active = $list['is_active'] === 'yes' ? 'active' : '';
                            ?>
                            <li class="feature-list-item <?php echo esc_attr($active); ?> position-relative">
                                <?php if(!empty( $list['feature_title'] )) : ?>
                                <div class="ft-text">
                                    <?php echo elh_element_kses_intermediate( $list['feature_title'] ); ?>
                                </div>
                                <?php endif; ?>

                                <?php if( $list['enable_icon'] == true ) : ?>
                                <div class="ft-img">
                                    <?php if ( $list['type'] == 'icon' ): ?>
                                        <?php \Elementor\Icons_Manager::render_icon( $list['list_icon'], ['aria-hidden' => 'true'] );?>
                                    <?php else: ?>
                                        <img src="<?php echo esc_url($list['list_image']['url']); ?>" alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['list_image']['url']) : ''); ?>">
                                    <?php endif;?>
                                </div>
                                <?php endif; ?>
                            </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>