<section class="mt-about-section-2 pt-120 pb-120 tx-section" data-background="<?php echo esc_url($settings['image_1']['url']) ? esc_url($settings['image_1']['url']) : ''; ?>">
    <div class="container mt-container-1">
        <div class="mt-about-content-wrap d-flex justify-content-end position-relative">
            <div class="mt-about-img-grp">
                <?php if(!empty( $settings['image_2']['url'] )) : ?>
                <div class="img_1 txt_item_active">
                    <img src="<?php echo esc_url($settings['image_2']['url']); ?>" alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_2']['url']) : ''); ?>">
                </div>
                <?php endif; ?>

                <?php if(!empty( $settings['image_3']['url'] )) : ?>
                <div class="img_2 txt_item_active">
                    <img src="<?php echo esc_url($settings['image_3']['url']); ?>" alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_3']['url']) : ''); ?>">
                </div>
                <?php endif; ?>
            </div>
            <div class="mt-about-content-2">
                <div class="mt-about-text-2">
                    <div class="mt-section-title ver_2 headline">
                        <?php if(!empty( $settings['sub_title'] )) : ?>
                        <div class="subtitle-2 wow fadeInRight" data-wow-delay="400ms" data-wow-duration="1000ms">
                            <?php echo elh_element_kses_intermediate($settings['sub_title']); ?>
                        </div>
                        <?php endif; ?>
                        <?php
                            if($settings['enable_title'] === 'yes') {
                            $this->add_render_attribute( 'title', 'class', 'tx-title sec_title title_text title_text_ani' );
                                printf('<%1$s %2$s>%3$s</%1$s>',
                                    tag_escape($settings['title_tag']),
                                    $this->get_render_attribute_string('title'),
                                    elh_element_kses_basic( $settings['title'] )
                                );
                            }
                        ?>
                    </div>
                    <div class="item-img-text d-flex pt-40">
                        <?php if(!empty( $settings['image_4']['url'] )) : ?>
                        <div class="item-img wow zoomIn" data-wow-delay="400ms" data-wow-duration="1000ms">
                            <img src="<?php echo esc_url($settings['image_4']['url']); ?>" alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_4']['url']) : ''); ?>">
                        </div>
                        <?php endif; ?>

                        <div class="item-text pera-content mt-text">
                            <?php if(!empty( $settings['description'] )) : ?>
                            <p><?php echo elh_element_kses_intermediate($settings['description']); ?></p>
                            <?php endif; ?>

                            <div class="mt-about-tab-text wow fadeInRight" data-wow-delay="400ms" data-wow-duration="1000ms">
                                <div class="mt-about-tab-list dark_version mt-30 d-flex align-items-center">
                                    <?php if( $settings['enable_info_text_box'] === 'yes' ) : ?>
                                    <div class="item-icon text-center d-flex justify-content-center align-items-center">
                                        <div class="m-icon-text">
                                            <?php if(!empty( $settings['info_text_image']['url'] )) : ?>
                                            <div class="m-icon d-flex justify-content-center align-items-center">
                                                <img src="<?php echo esc_url($settings['info_text_image']['url']); ?>"
                                                alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['info_text_image']['url']) : ''); ?>">
                                            </div>
                                            <?php endif; ?>

                                            <?php if(!empty( $settings['info_text_title'] )) : ?>
                                            <span><?php echo elh_element_kses_intermediate($settings['info_text_title']); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <?php endif; ?>

                                    <?php if( $settings['enable_info_feature_lists'] === 'yes' ) :
                                        $list_items = explode("\n", $settings['info_feature_lists']);
                                    ?>
                                    <div class="item-list ul-li-block">
                                        <ul>
                                            <?php foreach ($list_items as $list): ?>
                                            <li><?php echo wp_kses($list, true)?></li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <?php if( $settings['enable_button'] === 'yes' ) : ?>
                            <div class="mt-btn-3 mt-25 ver_2 text-uppercase">
                                <a class="tx-button" href="<?php echo esc_url($settings['button_link']['url']); ?>"
                                target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                                rel="<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                                    <?php echo esc_html($settings['button_text']); ?>
                                <?php
                                    if(!empty( $settings['enable_button_icon'] === 'yes') ) {
                                        \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] );
                                    }
                                ?>
                                </a>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>