<?php $rand = rand(0, 9999); ?>
<section class="mt-about-section-1 tx-section" data-background="<?php echo esc_url($settings['image_1']['url']) ? esc_url($settings['image_1']['url']) : ''; ?>">
    <div class="container mt-container-1">
        <div class="mt-about-content-1 d-flex">
            <div class="mt-about-tab-content">
                <div class="mt-about-tab-btn tx-tab-btn ul-li">
                    <ul class="nav nav-tabs" id="mt-about-tab_<?php echo esc_attr($rand); ?>" role="tablist">
                        <?php
                            foreach ($settings['txTab_lists'] as $id => $list):
                            $_id = $id + 1;
                            $is_active = $list['is_active'] == 'yes' ? 'active' : '';
                            $aria_selected = $list['is_active'] == 'yes' ? 'true' : 'false';
                        ?>
                        <li class="nav-item" role="presentation">
                            <div class="nav-link <?php echo esc_attr($is_active); ?>"
                                id="projectTab-<?php echo esc_attr($id. '_' .$rand); ?>"
                                data-bs-toggle="tab"
                                data-bs-target="#tab-<?php echo esc_attr($id. '_' .$rand); ?>"
                                type="button"
                                role="tab"
                                aria-controls="tab-<?php echo esc_attr($id. '_' .$rand); ?>"
                                aria-selected="<?php echo esc_attr($aria_selected); ?>">
                                <?php echo elh_element_kses_intermediate($list['tab_title']); ?>
                            </div>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <div class="mt-about-tab-desc mt-45">
                    <div class="tab-content" id="myTabContent_<?php echo esc_attr($rand); ?>">
                        <?php
                            foreach ($settings['txTab_lists'] as $id => $list):
                            $is_active = $list['is_active'] == 'yes' ? 'show active' : '';
                        ?>
                        <div class="tab-pane <?php echo esc_attr($is_active); ?> animated fadeInUp "
                        id="tab-<?php echo esc_attr($id. '_' .$rand); ?>"
                        role="tabpanel"
                        aria-labelledby="projectTab-<?php echo esc_attr($id. '_' .$rand); ?>">
                            <div class="mt-about-tab-text">
                                <div class="mt-section-title  headline pera-content">
                                    <?php if(!empty( $list['tab_content_subtitle'] )) : ?>
                                    <div class="subtitle wow fadeInRight" data-wow-delay="400ms" data-wow-duration="1000ms">
                                        <?php echo elh_element_kses_intermediate($list['tab_content_subtitle']); ?>
                                    </div>
                                    <?php endif; ?>

                                    <?php if(!empty( $list['tab_content_title'] )) : ?>
                                    <h2 class="sec_title title_text title_text_ani">
                                        <?php echo elh_element_kses_intermediate($list['tab_content_title']); ?>
                                    </h2>
                                    <?php endif; ?>
                                </div>
                                <div class="mt-about-tab-list mt-25 d-flex align-items-center">
                                    <div class="item-icon text-center d-flex justify-content-center align-items-center">
                                        <div class="m-icon-text">
                                            <?php if(!empty( $list['tab_image']['url'] )) : ?>
                                            <div class="m-icon d-flex justify-content-center align-items-center">
                                                <img src="<?php echo esc_url($list['tab_image']['url']); ?>" alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $list['tab_image']['url'] ); } ?>">
                                            </div>
                                            <?php endif; ?>

                                            <?php if(!empty( $list['tab_image_heading'] )) : ?>
                                            <span><?php echo elh_element_kses_intermediate($list['tab_image_heading']); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <?php
                                        if(!empty( $list['tab_content'] )) :
                                        $list_items = explode("\n", $list['tab_content']);
                                    ?>
                                    <div class="item-list ul-li-block">
                                        <ul>
                                            <?php foreach ($list_items as $list_item): ?>
                                            <li>
                                                <?php echo elh_element_kses_intermediate($list_item); ?>
                                            </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            <div class="mt-about-text-wrap  mt-text headline pera-content">
                <?php if( $settings['enable_author_box'] === 'yes' ) : ?>
                <div class="mt-about-client d-flex align-items-center">
                    <?php if(!empty( $settings['author_image']['url'] )) : ?>
                    <div class="item-img">
                        <img src="<?php echo esc_url($settings['author_image']['url']); ?>" alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['author_image']['url'] ); } ?>">
                    </div>
                    <?php endif; ?>
                    <div class="item-text ul-li">
                        <?php if( $settings['enable_rating'] === 'yes' ) : ?>
                        <ul>

                            <?php
                                $rating = $settings['rating_star'];
                                for ($i = 1; $i <= 5; $i++) {
                                    if ($i <= $rating) {
                                        echo '<li><i class="fa-solid fa-star"></i></li>';
                                    } else {
                                        echo '<li><i class="fa-solid fa-star-empty"></i></li>';
                                    }
                                }
                            ?>
                        </ul>
                        <?php endif; ?>
                        <?php if(!empty( $settings['author_text'] )) : ?>
                        <span>
                            <?php echo elh_element_kses_intermediate($settings['author_text']); ?>
                        </span>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>

                <?php if( $settings['enable_description'] === 'yes' ) : ?>
                <h3 class="title_text title_text_ani">
                    <?php echo elh_element_kses_intermediate($settings['description']); ?>
                </h3>
                <?php endif; ?>

                <?php if(!empty( $settings['short_description_1'] )) : ?>
                <p>
                    <?php echo elh_element_kses_intermediate($settings['short_description_1']); ?>
                </p>
                <?php endif; ?>

                <div class="mt-about-cta d-flex align-items-center">
                    <?php if( $settings['enable_contact_info_lists'] === 'yes' ) : ?>
                    <div class="cta-info">
                        <?php foreach($settings['contact_info_lists'] as $list) : ?>
                        <div class="cta-item d-flex align-items-center">
                            <?php if(!empty( $list['contact_info_icon'] )) : ?>
                            <div class="item-icon d-flex align-items-center justify-content-center">
                                <?php \Elementor\Icons_Manager::render_icon( $list['contact_info_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                            </div>
                            <?php endif; ?>

                            <?php if(!empty( $list['contact_info_title'] )) : ?>
                            <div class="item-text">
                                <a href="<?php echo esc_url($list['contact_info_link']['url']); ?>">
                                    <?php echo elh_element_kses_intermediate($list['contact_info_title']); ?>
                                </a>
                            </div>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <?php endif; ?>

                    <?php if(!empty( $settings['short_description_1'] )) : ?>
                    <div class="cta-text">
                        <p>
                            <?php echo elh_element_kses_intermediate($settings['short_description_2']); ?>
                        </p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>