<?php
namespace ElementHelper\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Repeater;
use \Elementor\Utils;

defined( 'ABSPATH' ) || die();

class Tx_About extends Element_El_Widget {

    /**
     * Get widget name.
     *
     * Retrieve Mojito Core widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'tx_about';
    }

    /**
     * Get widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Tx About', 'mojito-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/icon-box/';
    }

    /**
     * Get widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-preview-medium';
    }

    public function get_keywords() {
        return ['shape', 'mojito'];
    }

    protected function register_content_controls() {

        $this->start_controls_section(
            '_section_design_title',
            [
                'label' => __( 'Design Style', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'mojito-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'mojito-core' ),
                    'style_2' => __( 'Style 2', 'mojito-core' ),
                    'style_3' => __( 'Style 3', 'mojito-core' ),
                    'style_4' => __( 'Style 4', 'mojito-core' ),
                    'style_5' => __( 'Style 5', 'mojito-core' ),
                    'style_6' => __( 'Style 6', 'mojito-core' ),
                    'style_7' => __( 'Style 7', 'mojito-core' ),
                    'style_8' => __( 'Style 8', 'mojito-core' ),
                    'style_9' => __( 'Style 9', 'mojito-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_title',
            [
                'label' => __( 'Title & Description', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // sub title
        $this->add_control(
            'sub_title',
            [
                'label'       => __( 'Sub Title', 'mojito-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXTAREA,
                'rows'        => 4,
                'default'     => 'Sub Title',
                'placeholder' => __( 'Sub Title Text', 'mojito-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'enable_sub_title' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'mojito-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXTAREA,
                'rows'        => 4,
                'default'     => 'Heading Title',
                'placeholder' => __( 'Heading Text', 'mojito-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'enable_title' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label'     => __( 'Title HTML Tag', 'mojito-core' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'h1' => [
                        'title' => __( 'H1', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h1',
                    ],
                    'h2' => [
                        'title' => __( 'H2', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h2',
                    ],
                    'h3' => [
                        'title' => __( 'H3', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h3',
                    ],
                    'h4' => [
                        'title' => __( 'H4', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h4',
                    ],
                    'h5' => [
                        'title' => __( 'H5', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h5',
                    ],
                    'h6' => [
                        'title' => __( 'H6', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h6',
                    ],
                ],
                'default'   => 'h2',
                'toggle'    => false,
                'condition' => [
                    'enable_title' => 'yes',
                ],
            ]
        );

        // description
        $this->add_control(
            'description',
            [
                'label'       => __( 'Description', 'mojito-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXTAREA,
                'rows'        => 4,
                'default'     => 'The opportunity to work abroad is a popular prospect, one',
                'placeholder' => __( 'Description Text', 'mojito-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'enable_description' => 'yes',
                ],
            ]
        );

        // short description 1
        $this->add_control(
            'short_description_1',
            [
                'label'       => __( 'Short Description 1', 'mojito-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXTAREA,
                'rows'        => 4,
                'default'     => 'The opportunity to work abroad is a popular prospect, one',
                'placeholder' => __( 'Short Description 1 Text', 'mojito-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'design_style' => ['style_1'],
                ],
            ]
        );

        // short description 2
        $this->add_control(
            'short_description_2',
            [
                'label'       => __( 'Short Description 2', 'mojito-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXTAREA,
                'rows'        => 4,
                'default'     => 'The opportunity to work abroad is a popular prospect, one',
                'placeholder' => __( 'Short Description 2 Text', 'mojito-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'design_style' => ['style_1'],
                ],
            ]
        );

        $this->end_controls_section();

        // images
        $this->start_controls_section(
            '_section_images',
            [
                'label' => __( 'Images', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // IMAGE_1
        $this->add_control(
            'image_1',
            [
                'label'       => __( 'Image 1', 'mojito-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'default'     => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // IMAGE_2
        $this->add_control(
            'image_2',
            [
                'label'       => __( 'Image 2', 'mojito-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'default'     => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition'   => [
                    'design_style' => ['style_2', 'style_3', 'style_4', 'style_5', 'style_7', 'style_8'],
                ],
            ]
        );

        // IMAGE_3
        $this->add_control(
            'image_3',
            [
                'label'       => __( 'Image 3', 'mojito-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'default'     => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition'   => [
                    'design_style' => ['style_2', 'style_3', 'style_4'],
                ],
            ]
        );

        // IMAGE_4
        $this->add_control(
            'image_4',
            [
                'label'       => __( 'Image 4', 'mojito-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'default'     => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition'   => [
                    'design_style' => ['style_2', 'style_3'],
                ],
            ]
        );

        // NASK IMAGE
        $this->add_control(
            'mask_image',
            [
                'label'       => __( 'Mask Image', 'mojito-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::MEDIA,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic'     => [
                    'active' => true,
                ],
                'selectors'   => [
                    '{{WRAPPER}} .mt-about-section-1' => 'mask-image: url({{URL}});-webkit-mask-image: url({{URL}});',
                ],
                'condition'   => [
                    'design_style' => ['style_1'],
                ],
            ]
        );

           // shape iamge
           $this->add_control(
            'list_shape_image',
            [
                'label'       => __( 'Shape Image', 'mojito-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::MEDIA,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic'     => [
                    'active' => true,
                ],
                'selectors'   => [
                    '{{WRAPPER}} .mt-about-tab-text .tab-list li:before' => 'background-image: url({{URL}});',
                ],
                'condition'   => [
                    'design_style' => ['style_1'],
                ],
            ]
        );

        // END
        $this->end_controls_section();

        $this->start_controls_section(
            '_section_project_tab',
            [
                'label'     => __( 'Tabs', 'mojito-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_1'],
                ],
            ]
        );

        // enable tab
        $this->add_control(
            'enable_tab',
            [
                'label'        => __( 'Enable Tab', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // repeater
        $repeater = new Repeater();

        // design style
        $repeater->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'mojito-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'mojito-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        // is_active
        $repeater->add_control(
            'is_active',
            [
                'label'        => __( 'Active', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // tab_title
        $repeater->add_control(
            'tab_title',
            [
                'label'       => __( 'Tab Title', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Tab Title', 'mojito-core' ),
                'placeholder' => __( 'Type your title here', 'mojito-core' ),
                'label_block' => true,
            ]
        );

        // tab_content_subtitle
        $repeater->add_control(
            'tab_content_subtitle',
            [
                'label'       => __( 'Tab Content Subtitle', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Tab Content Subtitle', 'mojito-core' ),
                'placeholder' => __( 'Type your subtitle here', 'mojito-core' ),
                'label_block' => true,
            ]
        );

        // tab_content_title
        $repeater->add_control(
            'tab_content_title',
            [
                'label'       => __( 'Tab Content Title', 'mojito-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __( 'Tab Content Title', 'mojito-core' ),
                'placeholder' => __( 'Type your title here', 'mojito-core' ),
                'label_block' => true,
            ]
        );

        // TAB image
        $repeater->add_control(
            'tab_image',
            [
                'label'       => __( 'Tab Image', 'mojito-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );

        // TAB ICON HEADING
        $repeater->add_control(
            'tab_image_heading',
            [
                'label'       => __( 'Icon Heading', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Icon Heading', 'mojito-core' ),
                'placeholder' => __( 'Type your icon heading here', 'mojito-core' ),
                'label_block' => true,
            ]
        );

        // tab_content
        $repeater->add_control(
            'tab_content',
            [
                'label'       => __( 'Tab Content', 'mojito-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __( 'Tab Content', 'mojito-core' ),
                'placeholder' => __( 'Type your content here', 'mojito-core' ),
                'show_label'  => false,
            ]
        );

        // lists items
        $this->add_control(
            'txTab_lists',
            [
                'label'  => __( 'Tabs', 'mojito-core' ),
                'type'   => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->end_controls_section();

        // author box
        $this->start_controls_section(
            '_section_author_box',
            [
                'label'     => __( 'Author Box', 'mojito-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_1'],
                ],
            ]
        );

        // enable author box
        $this->add_control(
            'enable_author_box',
            [
                'label'        => __( 'Enable Author Box', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // author image
        $this->add_control(
            'author_image',
            [
                'label'       => __( 'Author Image', 'mojito-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // enable rating
        $this->add_control(
            'enable_rating',
            [
                'label'        => __( 'Enable Rating', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // rating star
        $this->add_control(
            'rating_star',
            [
                'label'     => __( 'Rating Star', 'mojito-core' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    '1' => __( '1 Star', 'mojito-core' ),
                    '2' => __( '2 Star', 'mojito-core' ),
                    '3' => __( '3 Star', 'mojito-core' ),
                    '4' => __( '4 Star', 'mojito-core' ),
                    '5' => __( '5 Star', 'mojito-core' ),
                ],
                'default'   => '5',
                'condition' => [
                    'enable_rating' => 'yes',
                ],
            ]
        );

        // author text
        $this->add_control(
            'author_text',
            [
                'label'       => __( 'Author Text', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __( 'Author Name', 'mojito-core' ),
                'placeholder' => __( 'Author Name', 'mojito-core' ),
            ]
        );

        // end
        $this->end_controls_section();

        // contact info lists
        $this->start_controls_section(
            '_section_contact_info_lists',
            [
                'label'     => __( 'Contact Info Lists', 'mojito-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_1'],
                ],
            ]
        );

        // enable contact info lists
        $this->add_control(
            'enable_contact_info_lists',
            [
                'label'        => __( 'Enable Contact Info Lists', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // repeater
        $repeater = new Repeater();

        // contact info icon
        $repeater->add_control(
            'contact_info_icon',
            [
                'label'       => __( 'Icon', 'mojito-core' ),
                'type'        => Controls_Manager::ICONS,
                'label_block' => true,
            ]
        );

        // contact info title
        $repeater->add_control(
            'contact_info_title',
            [
                'label'       => __( 'Title', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __( 'Contact Info Title', 'mojito-core' ),
                'placeholder' => __( 'Contact Info Title', 'mojito-core' ),
            ]
        );

        // contact info link
        $repeater->add_control(
            'contact_info_link',
            [
                'label'       => __( 'Link', 'mojito-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'mojito-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        // contact info lists
        $this->add_control(
            'contact_info_lists',
            [
                'label'  => __( 'Contact Info Lists', 'mojito-core' ),
                'type'   => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        // end
        $this->end_controls_section();

        // feature lists
        $this->start_controls_section(
            '_section_feature_lists',
            [
                'label'     => __( 'Feature Lists', 'mojito-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_3', 'style_7', 'style_9'],
                ],
            ]
        );

        // enable feature lists
        $this->add_control(
            'enable_feature_lists',
            [
                'label'        => __( 'Enable Feature Lists', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // feature list text
        $repeater = new Repeater();

        // design style
        $repeater->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'mojito-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'mojito-core' ),
                    'style_2' => __( 'Style 2', 'mojito-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        // is_active
        $repeater->add_control(
            'is_active',
            [
                'label'        => __( 'Active', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'no',
                'condition'    => [
                    'design_style' => ['style_1'],
                ],
            ]
        );

        // enable_icon
        $repeater->add_control(
            'enable_icon',
            [
                'label'        => __( 'Enable Icon', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'design_style' => ['style_1'],
                ],
            ]
        );

        $repeater->add_control(
            'type',
            [
                'label'          => __( 'List Icon', 'mojito-core' ),
                'type'           => Controls_Manager::CHOOSE,
                'label_block'    => false,
                'options'        => [
                    'icon'  => [
                        'title' => __( 'Icon', 'mojito-core' ),
                        'icon'  => 'far fa-smile',
                    ],
                    'image' => [
                        'title' => __( 'Image', 'mojito-core' ),
                        'icon'  => 'fa fa-image',
                    ],
                ],
                'default'        => 'icon',
                'toggle'         => false,
                'style_transfer' => true,
                'condition'      => [
                    'enable_icon' => 'yes',
                    'design_style' => ['style_1'],
                ],
            ]
        );

        // list icon
        $repeater->add_control(
            'list_icon',
            [
                'label'       => __( 'Icon', 'mojito-core' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fas fa-check',
                    'library' => 'solid',
                ],
                'label_block' => true,
                'condition'   => [
                    'type'        => 'icon',
                    'enable_icon' => 'yes',
                    'design_style' => ['style_1'],
                ],
            ]
        );

        // list image
        $repeater->add_control(
            'list_image',
            [
                'label'       => __( 'Image', 'mojito-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'condition'   => [
                    'type'        => 'image',
                    'enable_icon' => 'yes',
                    'design_style' => ['style_1'],
                ],
            ]
        );

        // feature count
        $repeater->add_control(
            'feature_count',
            [
                'label'       => __( 'Feature Count', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => 1,
                'label_block' => true,
                'condition'   => [
                    'design_style' => ['style_2'],
                ],
            ]
        );

        // featre text
        $repeater->add_control(
            'feature_title',
            [
                'label'       => __( 'Feature Title', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __( 'Feature Title', 'mojito-core' ),
                'placeholder' => __( 'Feature Title', 'mojito-core' ),
            ]
        );

        // feature description
        $repeater->add_control(
            'feature_description',
            [
                'label'       => __( 'Feature Description', 'mojito-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'rows'        => 4,
                'default'     => __( 'Feature Description', 'mojito-core' ),
                'placeholder' => __( 'Feature Description', 'mojito-core' ),
                'condition'   => [
                    'design_style' => ['style_2'],
                ],
            ]
        );

        // link
        $repeater->add_control(
            'button_link',
            [
                'label'       => __( 'Link', 'mojito-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'mojito-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'design_style' => ['style_3', 'style_4'],
                ],
            ]
        );

        // feature lists
        $this->add_control(
            'feature_lists',
            [
                'label'       => __( 'Feature Lists', 'mojito-core' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ feature_title }}}',
                'condition'   => [
                    'enable_feature_lists' => 'yes',
                ],
            ]
        );

        // end
        $this->end_controls_section();

        // count box
        $this->start_controls_section(
            '_section_count_box_style',
            [
                'label'     => __( 'Count Box', 'mojito-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_4', 'style_5', 'style_8'],
                ],
            ]
        );

        // enable count box
        $this->add_control(
            'enable_count_box',
            [
                'label'        => __( 'Enable Count Box', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // count number
        $this->add_control(
            'count_number',
            [
                'label'     => __( 'Number', 'mojito-core' ),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 100,
                'condition' => [
                    'design_style' => ['style_4'],
                ],
            ]
        );

        // count prefix
        $this->add_control(
            'count_prefix',
            [
                'label'     => __( 'Prefix', 'mojito-core' ),
                'type'      => Controls_Manager::TEXT,
                'default'   => '+',
                'condition' => [
                    'design_style' => ['style_4'],
                ],
            ]
        );

        // count title
        $this->add_control(
            'count_title',
            [
                'label'       => __( 'Title', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __( 'Happy Clients', 'mojito-core' ),
                'condition'   => [
                    'design_style' => ['style_4'],
                ],
            ]
        );

        // repeater
        $repeater = new Repeater();

        // design style
        $repeater->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'mojito-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'mojito-core' ),
                    'style_2' => __( 'Style 2', 'mojito-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        // count suffix
        $repeater->add_control(
            'count_suffix',
            [
                'label'       => __( 'Suffix', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => '+',
                'label_block' => true,
                'condition'   => [
                    'design_style' => ['style_1'],
                ],
            ]
        );

        // count number
        $repeater->add_control(
            'count_number',
            [
                'label'       => __( 'Number', 'mojito-core' ),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 100,
                'label_block' => true,
            ]
        );

        // count prefix
        $repeater->add_control(
            'count_prefix',
            [
                'label'       => __( 'Prefix', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => '+',
                'label_block' => true,
            ]
        );

        // count title
        $repeater->add_control(
            'count_title',
            [
                'label'       => __( 'Title', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __( 'Happy Clients', 'mojito-core' ),
            ]
        );

        // count_description
        $repeater->add_control(
            'count_description',
            [
                'label'       => __( 'Description', 'mojito-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'rows'        => 4,
                'default'     => __( 'Happy Clients', 'mojito-core' ),
                'placeholder' => __( 'Happy Clients', 'mojito-core' ),
                'condition'   => [
                    'design_style' => ['style_2'],
                ],
            ]
        );

        // count box lists
        $this->add_control(
            'count_box_lists',
            [
                'label'  => __( 'Count Box Lists', 'mojito-core' ),
                'type'   => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        // END
        $this->end_controls_section();

        // contact info box
        $this->start_controls_section(
            '_section_contact_info_box',
            [
                'label'     => __( 'Contact Info Box', 'mojito-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_20'],
                ],
            ]
        );

        // enable contact info
        $this->add_control(
            'enable_contact_info',
            [
                'label'        => __( 'Enable Contact Info', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // contact info icon
        $this->add_control(
            'contact_info_icon',
            [
                'label'   => __( 'Contact Info Icon', 'mojito-core' ),
                'type'    => Controls_Manager::ICONS,
                'default' => [
                    'value'   => 'fas fa-phone',
                    'library' => 'fa-solid',
                ],
            ]
        );

        // contact info label
        $this->add_control(
            'contact_info_label',
            [
                'label'       => __( 'Contact Info Label', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Contact Info Label', 'mojito-core' ),
                'placeholder' => __( 'Enter your contact info label', 'mojito-core' ),

            ]
        );

        // contact info text
        $this->add_control(
            'contact_info_text',
            [
                'label'       => __( 'Contact Info Text', 'mojito-core' ),
                'type'        => Controls_Manager::WYSIWYG,
                'default'     => __( 'Contact Info Text', 'mojito-core' ),
                'placeholder' => __( 'Enter your contact info text', 'mojito-core' ),
            ]
        );

        // end
        $this->end_controls_section();

        // BUTTON
        $this->start_controls_section(
            '_section_button',
            [
                'label'     => __( 'Button', 'mojito-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_2', 'style_3', 'style_4', 'style_5', 'style_6'],
                ],
            ]
        );

        // enable button
        $this->add_control(
            'enable_button',
            [
                'label'        => __( 'Enable Button', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // BUTTON TEXT
        $this->add_control(
            'button_text',
            [
                'label'       => __( 'Button Text', 'mojito-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Button Text', 'mojito-core' ),
                'placeholder' => __( 'Button Text', 'mojito-core' ),
                'dynamic'     => [
                    'active' => true,
                ],

            ]
        );

        // BUTTON LINK
        $this->add_control(
            'button_link',
            [
                'label'       => __( 'Button Link', 'mojito-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'mojito-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        // ENABLE BUTTON ICON
        $this->add_control(
            'enable_button_icon',
            [
                'label'        => __( 'Enable Button Icon', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );

        // BUTTON ICON
        $this->add_control(
            'button_icon',
            [
                'label'       => __( 'Button Icon', 'mojito-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fas fa-angle-right',
                    'library' => 'fa-solid',
                ],
                'condition'   => [
                    'enable_button_icon' => 'yes',
                ],
            ]
        );

        // END
        $this->end_controls_section();

        // info text box
        $this->start_controls_section(
            '_section_info_text_box',
            [
                'label'     => __( 'Info Text Box', 'mojito-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_2', 'style_4', 'style_5', 'style_6'],
                ],
            ]
        );

        // enable info text box
        $this->add_control(
            'enable_info_text_box',
            [
                'label'        => __( 'Enable Info Text Box', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'design_style' => ['style_2', 'style_6'],
                ],
            ]
        );

        // info text image
        $this->add_control(
            'info_text_image',
            [
                'label'       => __( 'Info Text Image', 'mojito-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition'   => [
                    'design_style' => ['style_2'],
                ],
            ]
        );

        // info text title
        $this->add_control(
            'info_text_title',
            [
                'label'       => __( 'Info Text Title', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __( 'Info Text Title', 'mojito-core' ),
                'placeholder' => __( 'Info Text Title', 'mojito-core' ),
                'condition'   => [
                    'design_style' => ['style_2', 'style_6'],
                ],
            ]
        );

        // info_text_title2
        $this->add_control(
            'info_text_title_2',
            [
                'label'       => __( 'Info Text Title 2', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __( 'Info Text Title 2', 'mojito-core' ),
                'placeholder' => __( 'Info Text Title 2', 'mojito-core' ),
                'condition'   => [
                    'design_style' => ['style_6'],
                ],
            ]
        );

        // enable info feature lists
        $this->add_control(
            'enable_info_feature_lists',
            [
                'label'        => __( 'Enable Info Feature Lists', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',

            ]
        );

        // info feature icon
        $this->add_control(
            'info_feature_icon',
            [
                'label'       => __( 'Feature Icon', 'mojito-core' ),
                'type'        => Controls_Manager::ICONS,
                'label_block' => true,
                'default'     => [
                    'value'   => 'fas fa-check',
                    'library' => 'fa-solid',
                ],
                'condition'   => [
                    'enable_info_feature_lists' => 'yes',
                    'design_style'             => ['style_6'],
                ],
            ]
        );

        // feature list text
        $this->add_control(
            'info_feature_lists',
            [
                'label'       => __( 'Info Text Title', 'mojito-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default'     => __( 'Info Text Title', 'mojito-core' ),
                'placeholder' => __( 'Info Text Title', 'mojito-core' ),
            ]
        );

        // end
        $this->end_controls_section();

        // SETTINGS
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => __( 'Settings', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // enable navigation
        $this->add_control(
            'enable_navigation',
            [
                'label'        => __( 'Enable Navigation', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'design_style' => ['style_3'],
                ],
            ]
        );

        // enable_shape_1
        $this->add_control(
            'enable_shape_1',
            [
                'label'        => __( 'Enable Shape 1', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // ENABLE SUB TITLE
        $this->add_control(
            'enable_sub_title',
            [
                'label'        => __( 'Enable Sub Title', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // ENABLE TITLE
        $this->add_control(
            'enable_title',
            [
                'label'        => __( 'Enable Title', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // ENABLE DESCRIPTION
        $this->add_control(
            'enable_description',
            [
                'label'        => __( 'Enable Description', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $this->end_controls_section();

    }

    protected function register_style_controls() {

        $dir = dirname( __FILE__ );
        $style_files = glob( $dir . '/styles/*.php' );

        if ( $style_files ) {
            foreach ( $style_files as $style_file ) {
                include $style_file;
            }
        }

    }

    /**
     * Render widget output on the frontend.
     *
     * Used to generate the final HTML displayed on the frontend.
     *
     * Note that if skin is selected, it will be rendered by the skin itself,
     * not the widget.
     *
     * @since 1.0.0
     * @access public
     */
    protected function render() {

        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        $style = !empty( $settings['design_style'] ) ? $settings['design_style'] : 'style_1';

        switch ( $style ) {
        case 'style_10':
            include $dir . '/views/view-10.php';
            break;
        case 'style_9':
            include $dir . '/views/view-9.php';
            break;
        case 'style_8':
            include $dir . '/views/view-8.php';
            break;
        case 'style_7':
            include $dir . '/views/view-7.php';
            break;
        case 'style_6':
            include $dir . '/views/view-6.php';
            break;
        case 'style_5':
            include $dir . '/views/view-5.php';
            break;
        case 'style_4':
            include $dir . '/views/view-4.php';
            break;
        case 'style_3':
            include $dir . '/views/view-3.php';
            break;
        case 'style_2':
            include $dir . '/views/view-2.php';
            break;
        default:
            include $dir . '/views/view-1.php';
        }
    }

}